﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    public class MouseInformationProvider : IInformationProvider
    {
         public string InformationDescription { get { return "Mouse"; } }

         public ContextInformation GetInformation()
         {
             var mouseInfo = new ContextInformationContainer();
             mouseInfo.Add("Mouse present", new DecimalContextInformation(SystemInformation.MousePresent ? 1 : 0));
             mouseInfo.Add("Mouse speed (1 - 20)", new DecimalContextInformation(SystemInformation.MouseSpeed));
             mouseInfo.Add("Mouse buttons", new DecimalContextInformation(SystemInformation.MouseButtons));
             mouseInfo.Add("Mouse buttons swapped", new DecimalContextInformation(SystemInformation.MouseButtonsSwapped ? 1 : 0));
             mouseInfo.Add("Native mouse wheel OS support", new DecimalContextInformation(SystemInformation.NativeMouseWheelSupport ? 1 : 0));
             mouseInfo.Add("Mouse wheel present", new DecimalContextInformation(SystemInformation.MouseWheelPresent ? 1 : 0));
             mouseInfo.Add("Mouse wheel scroll delta", new DecimalContextInformation(SystemInformation.MouseWheelScrollDelta));
             mouseInfo.Add("Mouse wheel scroll lines", new DecimalContextInformation(SystemInformation.MouseWheelScrollLines));
             mouseInfo.Add("Cursor size", SystemInformation.CursorSize.ToInformationContainer());
             mouseInfo.Add("Mouse hover size", SystemInformation.MouseHoverSize.ToInformationContainer());
             mouseInfo.Add("Mouse hover time (ms)", new DecimalContextInformation(SystemInformation.MouseHoverTime));
             mouseInfo.Add("Double click size", SystemInformation.DoubleClickSize.ToInformationContainer());
             mouseInfo.Add("Double click time (ms)", new DecimalContextInformation(SystemInformation.DoubleClickTime));
             mouseInfo.Add("Full window drag enabled", new DecimalContextInformation(SystemInformation.DragFullWindows ? 1 : 0));
             mouseInfo.Add("Drag size", SystemInformation.DragSize.ToInformationContainer());

             return mouseInfo;
         }
    }
}
