﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using EnvironmentReporting;
using System.Windows.Forms;

namespace EnvironmentInformationProvider
{
    public class FontsInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Fonts"; } }

        public ContextInformation GetInformation()
        {
            var fontInfo = new ContextInformationContainer();

            fontInfo.Add("Font smoothing enabled", new DecimalContextInformation(SystemInformation.IsFontSmoothingEnabled ? 1 : 0));
            try { fontInfo.Add("Font smoothing contrast", new DecimalContextInformation(SystemInformation.FontSmoothingContrast)); }
            catch (NotSupportedException) { fontInfo.Add("Font smoothing contrast", new StringContextInformation("Not supported")); }
            try { fontInfo.Add("Font smoothing type", new DecimalContextInformation(SystemInformation.FontSmoothingType)); }
            catch (NotSupportedException) { fontInfo.Add("Font smoothing type", new StringContextInformation("Not supported")); }

            return fontInfo;
        }
    }
}
