﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    public class DisplayInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Display devices"; } }

        public ContextInformation GetInformation()
        {
            var displayInfo = new ContextInformationContainer();

            displayInfo.Add("Number of monitors", new DecimalContextInformation(SystemInformation.MonitorCount));
            displayInfo.Add("All monitors using same pixel color format", new DecimalContextInformation(SystemInformation.MonitorsSameDisplayFormat ? 1 : 0));
            displayInfo.Add("Primary display size", SystemInformation.PrimaryMonitorSize.ToInformationContainer());
            displayInfo.Add("Primary display maximized window size", SystemInformation.PrimaryMonitorMaximizedWindowSize.ToInformationContainer());
            displayInfo.Add("Screen orientation", new StringContextInformation(SystemInformation.ScreenOrientation.ToString()));
            displayInfo.Add("Virtual screen", SystemInformation.VirtualScreen.ToInformationContainer());
            displayInfo.Add("Working area", SystemInformation.WorkingArea.ToInformationContainer());

            var screensInfo = new ContextInformationContainer();
            int i = 0;
            foreach (var screen in Screen.AllScreens)
            {
                var screenInfo = new ContextInformationContainer();
                screenInfo.Add("Bits per pixel", new DecimalContextInformation(screen.BitsPerPixel));

                var resolutionInfo = new ContextInformationContainer();
                resolutionInfo.Add("Width", new DecimalContextInformation(screen.Bounds.Width));
                resolutionInfo.Add("Height", new DecimalContextInformation(screen.Bounds.Height));
                screenInfo.Add("Resolution", resolutionInfo);

                var workingAreaInfo = new ContextInformationContainer();
                workingAreaInfo.Add("Width", new DecimalContextInformation(screen.WorkingArea.Width));
                workingAreaInfo.Add("Height", new DecimalContextInformation(screen.WorkingArea.Height));
                screenInfo.Add("Working area", workingAreaInfo);

                screensInfo.Add(i.ToString(), screenInfo);
                ++i;
            }
            displayInfo.Add("Screens", screensInfo);

            using (Graphics g = Graphics.FromHwnd(IntPtr.Zero))
            {
                displayInfo.Add("DPI X", new DecimalContextInformation(new decimal(g.DpiX)));
                displayInfo.Add("DPI Y", new DecimalContextInformation(new decimal(g.DpiY)));
            }

            return displayInfo;
        }
    }
}
