﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using EffectDefinitions;

namespace EffectDefinitionsUnitTests
{
    [TestClass]
    public class ShaderTypeDefinitionTests
    {
        [TestMethod]
        public void NatureOfTypeTest()
        {
            var voidTypeName = "void";
            var voidType = new ShaderTypeDefinition(voidTypeName);
            if (voidType.IsVoid == false)
                throw new Exception(string.Format("Type \"{0}\" is not considered void but should", voidTypeName));

            var typeNames = new[] { "*", "?", "bool", "int", "uint", "float", "vec2", "vec3", "vec4", "mat2", "mat3" };
            foreach (var typeName in typeNames)
            {
                var type = new ShaderTypeDefinition(typeName);
                if (type.IsVoid)
                    throw new Exception(string.Format("Type \"{0}\" is considered void but should not", typeName));
            }
        }
    }
}
