﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectDefinitions
{
    /// <summary>
    /// uniform 変数情報のソースです。
    /// </summary>
    public class UniformDefinitionWithSource : UniformDefinition
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">glsl ファイルのソース情報</param>
        /// <param name="nameSource">glsl ファイルの uniform 変数名情報</param>
        /// <param name="name">uniform 変数名</param>
        /// <param name="displaynameSource">glsl ファイルの表示名情報</param>
        /// <param name="displayname">表示名</param>
        /// <param name="typeSource">glsl ファイルの uniform 変数の型名情報</param>
        /// <param name="type">uniform 変数の型名</param>
        /// <param name="extensionSource">glsl ファイルのファイルの拡張子情報</param>
        /// <param name="extension">ファイルの拡張子</param>
        public UniformDefinitionWithSource(
            DefinitionLocation source,
            DefinitionLocation nameSource,
            string name,
            DefinitionLocation displaynameSource,
            string displayname,
            DefinitionLocation typeSource,
            string type,
            DefinitionLocation extensionSource,
            string extension)
            : base(name, displayname, type, extension)
        {
            this.Source = source;
            this.NameSource = nameSource;
            this.DisplaynameSource = displaynameSource;
            this.TypeSource = typeSource;
            this.ExtensionSource = extensionSource;
        }

        /// <summary>
        /// glslファイルのソース情報を取得します。
        /// </summary>
        public DefinitionLocation Source { get; private set; }

        /// <summary>
        /// glsl ファイルの uniform 変数名情報を取得します。
        /// </summary>
        public DefinitionLocation NameSource { get; private set; }

        /// <summary>
        /// glsl ファイルの displayname 情報を取得します。
        /// </summary>
        public DefinitionLocation DisplaynameSource { get; private set; }

        /// <summary>
        /// glsl ファイルの uniform 変数の型名情報を取得します。
        /// </summary>
        public DefinitionLocation TypeSource { get; private set; }

        /// <summary>
        /// glsl ファイルのファイルの拡張子情報を取得します。
        /// </summary>
        public DefinitionLocation ExtensionSource { get; private set; }
    }
}
