﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectDefinitions
{
    /// <summary>
    /// Tag -- function pair: it has a source, a tag and a function id.
    /// </summary>
    public class Tagging : IEquatable<Tagging>
    {
        public Tagging(DefinitionLocation source,
            string name,
            string functionId)
        {
            Source = source;
            Name = name;
            FunctionId = functionId;
        }

        public DefinitionLocation Source { get; private set; }

        public string Name { get; private set; }
        public string FunctionId { get; private set; }

        public override string ToString()
        {
            return string.Format("{0} - {1}", Name, FunctionId);
        }

        #region Equals

        public override bool Equals(object obj)
        {
            if (obj is Tagging)
                return Equals((Tagging)obj);

            return false;
        }

        public virtual bool Equals(Tagging other)
        {
            if ((object)other == null)
                return false;

            return Name == other.Name &&
                FunctionId == other.FunctionId;
        }

        public override int GetHashCode()
        {
            return (Name + FunctionId).GetHashCode();
        }

        public static bool operator ==(Tagging t1, Tagging t2)
        {
            if ((object)t1 == null)
                return (object)t2 == null;

            return t1.Equals(t2);
        }

        public static bool operator !=(Tagging t1, Tagging t2)
        {
            return !(t1 == t2);
        }

        #endregion
    }
}
