﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

namespace EffectDefinitions
{
    /// <summary>
    /// Definition of a shader language type in a definitions file: a string representing the type.
    /// </summary>
    public class ShaderTypeDefinition : ShaderTyping.ShaderTypeDefinition
    {
        private const string VoidTypeString = "void";

        public static readonly ShaderTypeDefinition Void = new ShaderTypeDefinition();

        public ShaderTypeDefinition()
            : this(VoidTypeString)
        {
        }

        public ShaderTypeDefinition(string typeString)
        {
            if (string.IsNullOrWhiteSpace(typeString))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "typeString"), "typeString");

            TypeString = typeString;
        }

        public string TypeString { get; private set; }

        public override bool IsVoid { get { return TypeString == VoidTypeString; } }

        #region Equals

        public override bool Equals(object obj)
        {
            var other = obj as ShaderTypeDefinition;
            return other != null && Equals(other);
        }

        public override bool Equals(ShaderTyping.ShaderTypeDefinition other)
        {
            if ((object)other == null)
                return false;

            if (!(other is ShaderTypeDefinition))
                return false;

            return TypeString == ((ShaderTypeDefinition)other).TypeString;
        }

        public override int GetHashCode()
        {
            return TypeString.GetHashCode();
        }

        public override string ToString()
        {
            return TypeString;
        }

        #endregion
    }
}
