﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace EffectDefinitions
{
    /// <summary>
    /// Definition of a block, with sources of all its elements.
    /// </summary>
    public class BlockDefinitionWithSource : BlockDefinition
    {
        public BlockDefinitionWithSource(BlockDefinition definition)
            : base(
                  definition.Source,
                  definition.Name,
                  definition.Guid,
                  definition.Group,
                  definition.InputPlugs,
                  definition.OutputPlugs,
                  definition.Uniform,
                  definition.Preview,
                  definition.FunctionBindings)
        {
            this.NameSource = null;
            this.GuidSource = null;
        }

        public BlockDefinitionWithSource(
            DefinitionLocation source,
            DefinitionLocation nameSource,
            string name,
            DefinitionLocation guidSource,
            string guid,
            DefinitionLocation groupSource,
            string group,
            ICollection<Plug> inputPlugs,
            ICollection<Plug> outputPlugs,
            UniformDefinition uniform,
            PreviewDefinition preview,
            params FunctionBinding[] functionBindings)
            : base(source, name, guid, group, inputPlugs, outputPlugs, uniform, preview, functionBindings)
        {
            this.NameSource = nameSource;
            this.GuidSource = guidSource;
            this.GroupSource = groupSource;
        }

        public DefinitionLocation GuidSource { get; internal set; }
        public DefinitionLocation NameSource { get; internal set; }
        public DefinitionLocation GroupSource { get; internal set; }
    }
}
