﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.IO;
using System.Reflection;

namespace EffectCombiner.Core.IO
{
    /// <summary>
    /// ファイルIO関連の定数パラメータです。
    /// </summary>
    public class IOConstants
    {
        /// <summary>
        /// ExecutablePath プロパティのバッキングフィールドです。
        /// </summary>
        private static string executableFilePath;

        /// <summary>
        /// アプリケーションの exe ファイルパスを取得します。
        /// </summary>
        public static string ExecutableFilePath
        {
            get
            {
                if (string.IsNullOrEmpty(executableFilePath))
                {
                    var asm = Assembly.GetEntryAssembly();

                    executableFilePath = asm != null ?
                        Path.GetFullPath(asm.Location) :
                        Path.GetFullPath(Assembly.GetExecutingAssembly().Location);
                }

                return executableFilePath;
            }
        }

        /// <summary>
        /// ExecutableFolderPath プロパティのバッキーングフィールドです。
        /// </summary>
        private static string executableFolderPath;

        /// <summary>
        /// アプリケーションの exe の配置フォルダパスを取得します。
        /// </summary>
        public static string ExecutableFolderPath
        {
            get
            {
                if (string.IsNullOrEmpty(executableFolderPath))
                {
                    executableFolderPath = Path.GetDirectoryName(ExecutableFilePath);
                }

                return executableFolderPath;
            }
        }

        /// <summary>
        /// AppDataWorkPath プロパティのバッキングフィールドです。
        /// </summary>
        private static string appDataWorkPath;

        /// <summary>
        /// CombinerEditor の作業データ配置フォルダパスを取得します。
        /// </summary>
        public static string AppDataWorkPath
        {
            get
            {
                if (string.IsNullOrEmpty(appDataWorkPath))
                {
                    appDataWorkPath = Path.Combine(ExecutableFolderPath, "Work");
                }

                return appDataWorkPath;
            }
        }
    }
}
