﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace EffectCombiner.Core.Extensions
{
    public static class SynchronizationContextExtensions
    {
        public static void RunSync(this SynchronizationContext context, Action action)
        {
            if (context == null)
                throw new ArgumentNullException("context");

            context.Send(_ => action(), null);
        }

        public static T RunSync<T>(this SynchronizationContext context, Func<T> action)
        {
            if (context == null)
                throw new ArgumentNullException("context");

            var result = default(T);
            context.Send(_ => result = action(), null);
            return result;
        }

        public static void RunAsync(this SynchronizationContext context, Action action)
        {
            if (context == null)
                throw new ArgumentNullException("context");

            context.Post(_ => action(), null);
        }
    }
}
