﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EffectCombiner.Core.Extensions
{
    public static class ControlExtensions
    {
        public static void SuspendDrawing(this Control ctrl)
        {
            if (ctrl != null && ctrl.IsHandleCreated)
                NativeUtility.SendMessage(ctrl.Handle, NativeUtility.WM_SETREDRAW, false, 0);
        }

        public static void ResumeDrawing(this Control ctrl)
        {
            if (ctrl != null && ctrl.IsHandleCreated)
                NativeUtility.SendMessage(ctrl.Handle, NativeUtility.WM_SETREDRAW, true, 0);
        }

        public static object Invoke(this Control control, Action action, params object[] state)
        {
            if (control == null)
                throw new ArgumentNullException("control");

            if (state.Length == 0)
                return control.Invoke(action);
            return control.Invoke(action, state);
        }

        public static IAsyncResult BeginInvoke(this Control control, Action action, params object[] state)
        {
            if (control == null)
                throw new ArgumentNullException("control");

            if (state.Length == 0)
                return control.BeginInvoke(action);
            return control.BeginInvoke(action, state);
        }
    }
}
