﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Core
{
    public class AnonymousEqualityComparer<T> : IEqualityComparer<T>
    {
        private readonly Func<T, int> getHashCode;
        private readonly Func<T, T, bool> equals;

        public AnonymousEqualityComparer(Func<T, int> getHashCode, Func<T, T, bool> equals)
        {
            if (getHashCode == null)
                throw new ArgumentNullException("getHashCode");
            if (equals == null)
                throw new ArgumentNullException("equals");

            this.getHashCode = getHashCode;
            this.equals = equals;
        }

        public bool Equals(T x, T y)
        {
            return equals(x, y);
        }

        public int GetHashCode(T obj)
        {
            return getHashCode(obj);
        }
    }
}
