﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Core
{
    public class AnonymousDisposer : IDisposable
    {
        private Action action;

        public AnonymousDisposer(Action onDispose)
        {
            if (onDispose == null)
                throw new ArgumentNullException("onDispose");

            action = onDispose;
        }

        public void Dispose()
        {
            if (action != null)
                action();

            action = null;
        }
    }

    public class AggregateDisposer : IDisposable
    {
        private IEnumerable<IDisposable> disposables;

        public AggregateDisposer(params IDisposable[] disposables)
            : this((IEnumerable<IDisposable>)disposables)
        {
        }

        public AggregateDisposer(IEnumerable<IDisposable> disposables)
        {
            this.disposables = disposables;
        }

        public void Dispose()
        {
            if (disposables == null)
                return;

            foreach (var disposable in disposables.Where(d => d != null))
                disposable.Dispose();

            disposables = null;
        }
    }
}
