﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Communication.Contracts;
using Communication.Core;
using System.ServiceModel;

namespace UnitTests
{
    [TestClass]
    public class CommunicationServicesTests
    {
        [TestMethod]
        public void TestCommunicationServices1()
        {
            string testArg1 = null;
            string testArg2 = null;

            Func<string, string, ShaderTransferResult> test = (p1, p2) =>
                {
                    testArg1 = p1;
                    testArg2 = p2;
                    return ShaderTransferResult.EmitterNotFound;
                };

            var service = new TestShaderTransferService(test);

            var srv = new CommunicationServer<IShaderTransferService>();
            srv.Start(service).Wait();

            var proxy = CommunicationClient.CreateProxy<IShaderTransferService>();

            var res = proxy.Transfer("a", "b");

            srv.Stop();

            if (testArg1 != "a")
                throw new Exception();
            if (testArg2 != "b")
                throw new Exception();

            if (res != ShaderTransferResult.EmitterNotFound)
                throw new Exception();
        }

        [TestMethod]
        public void TestCommunicationServices2()
        {
            string testArg1 = null;
            string testArg2 = null;

            Func<string, string, ShaderTransferResult> test = (p1, p2) =>
            {
                testArg1 = p1;
                testArg2 = p2;
                return ShaderTransferResult.EmitterNotFound;
            };

            var service = new TestShaderTransferService(test);

            var srv = new CommunicationServer<IShaderTransferService>();
            srv.Start(service).ContinueWith(t1 =>
            {
                var proxy = CommunicationClient.CreateProxy<IShaderTransferService>();

                var res = proxy.Transfer("a", "b");

                srv.Stop().ContinueWith(t2 =>
                {
                    if (testArg1 != "a")
                        throw new Exception();
                    if (testArg2 != "b")
                        throw new Exception();

                    if (res != ShaderTransferResult.EmitterNotFound)
                        throw new Exception();
                }).Wait();
            }).Wait();
        }

        [TestMethod]
        public void TestCommunicationServices3()
        {
            var error = false;

            var proxy = CommunicationClient.CreateProxy<IShaderTransferService>();

            try
            {
                proxy.Transfer("a", "b");
                error = true;
            }
            catch (EndpointNotFoundException)
            {
            }

            if (error)
                throw new Exception();
        }

        [TestMethod]
        public void TestSeveralCommunicationServices1()
        {
            string testArgA1 = null;
            string testArgA2 = null;

            string testArgB1 = null;
            string testArgB2 = null;

            Func<string, string, ShaderTransferResult> testA = (p1, p2) =>
            {
                testArgA1 = p1;
                testArgA2 = p2;
                return ShaderTransferResult.EmitterNotFound;
            };

            Func<string, string, ShaderTransferResult> testB = (p1, p2) =>
            {
                testArgB1 = p1;
                testArgB2 = p2;
                return ShaderTransferResult.EmitterNotFound;
            };

            var serviceA = new TestShaderTransferService(testA);
            var serviceB = new TestShaderTransferService(testB);

            var srvA = new CommunicationServer<IShaderTransferService>();
            srvA.Start(serviceA).Wait();

            var srvB = new CommunicationServer<IShaderTransferService>();
            srvB.Start(serviceB).ContinueWith(t => System.Diagnostics.Debug.WriteLine("Task Status: {0}", t.Status));

            System.Threading.Thread.Sleep(50000);

            var proxy = CommunicationClient.CreateProxy<IShaderTransferService>();

            proxy.Transfer("a", "b");
        }
    }
}
