﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectCombiner.Primitives
{
    /// <summary>
    /// プラグ情報です。
    /// </summary>
    public class PlugInfo
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="index">プラグ番号</param>
        /// <param name="instanceIdentifier">接続元または接続先の識別子</param>
        public PlugInfo(int index, uint instanceIdentifier)
        {
            this.Index = index;
            this.InstanceIdentifier = instanceIdentifier;
        }

        /// <summary>
        /// プラグ番号を取得します。
        /// </summary>
        public int Index { get; private set; }

        /// <summary>
        /// 接続元または接続先の識別子を取得します。
        /// </summary>
        public uint InstanceIdentifier { get; private set; }
    }

    /// <summary>
    /// 入力プラグ情報です。
    /// </summary>
    public class InputPlugInfo
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="index">プラグ番号</param>
        /// <param name="remote">出力先のプラグ情報</param>
        public InputPlugInfo(int index, PlugInfo remote)
        {
            if (remote == null)
                throw new ArgumentNullException("remote");

            this.Index = index;
            this.Remote = remote;
        }

        /// <summary>
        /// プラグ番号を取得します。
        /// </summary>
        public int Index { get; private set; }

        /// <summary>
        /// 入力元のプラグ情報を取得します。
        /// </summary>
        public PlugInfo Remote { get; private set; }
    }

    /// <summary>
    /// 出力プラグ情報です。
    /// </summary>
    public class OutputPlugInfo
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="index">プラグ番号</param>
        /// <param name="remotes">入力元のプラグ情報</param>
        public OutputPlugInfo(int index, PlugInfo[] remotes)
        {
            if (remotes == null)
                throw new ArgumentNullException("remotes");

            this.Index = index;
            this.Remotes = remotes;
        }

        /// <summary>
        /// プラグ番号を取得します。
        /// </summary>
        public int Index { get; private set; }

        /// <summary>
        /// 出力先のプラグ情報を取得します。
        /// </summary>
        public PlugInfo[] Remotes { get; private set; }
    }
}
