﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Blocks.Core;
using Renderer2D.Core;
using EffectCombiner.Primitives.Extensions;

namespace EffectCombiner.Primitives.Operations
{
    public class MoveBlockOperation : OperationBase
    {
        private readonly uint instanceIdentifier;
        private readonly IPoint oldPosition;
        private readonly IPoint newPosition;
        private readonly ISize oldSize;
        private readonly ISize newSize;

        public MoveBlockOperation(BlockManagerBase blockManager, BlockElementBase blockElement,
            IPoint oldPosition, IPoint newPosition, ISize oldSize, ISize newSize)
            : base(OperationType.MoveBlock, blockManager)
        {
            if (blockElement == null)
                throw new ArgumentNullException("blockElement");

            instanceIdentifier = blockElement.InstanceIdentifier;
            this.oldPosition = oldPosition;
            this.newPosition = newPosition;
            this.oldSize = oldSize;
            this.newSize = newSize;
        }

        public override void Rollback()
        {
            var block = FindBlock(instanceIdentifier);
            block.SetPosition(oldPosition.X, oldPosition.Y);
            block.SetComputedSize(oldSize.Width, oldSize.Height);
        }

        public override void Execute()
        {
            var block = FindBlock(instanceIdentifier);
            block.SetPosition(newPosition.X, newPosition.Y);
            block.SetComputedSize(newSize.Width, newSize.Height);
        }
    }
}
