﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using EffectCombiner.Primitives.Generation;
using Blocks.Core;

namespace EffectCombiner.Primitives.Operations
{
    public class ConstTypeChangeOperation : OperationBase
    {
        private readonly uint instanceIdentifier;
        private readonly string[,] previousValue;
        private readonly ConstantBlockDefinition newBlockDef;
        private readonly ConstantBlockDefinition oldBlockDef;

        public ConstTypeChangeOperation(
            BlockManagerBase blockManager,
            ConstantBlockElement constantBlockElement,
            ConstantBlockDefinition newBlockDef,
            ConstantBlockDefinition oldBlockDef)
            : base(OperationType.ConstantTypeChange, blockManager)
        {
            if (constantBlockElement == null)
                throw new ArgumentNullException("constantBlockElement");
            if (newBlockDef == null)
                throw new ArgumentNullException("newBlockDef");
            if (oldBlockDef == null)
                throw new ArgumentNullException("oldBlockDef");

            this.instanceIdentifier = constantBlockElement.InstanceIdentifier;
            this.previousValue = constantBlockElement.Values;
            this.newBlockDef = newBlockDef;
            this.oldBlockDef = oldBlockDef;
        }

        public override void Rollback()
        {
            var block = FindBlock<ConstantBlockElement>(instanceIdentifier);

            block.UpdateBlockDefinition(oldBlockDef);
            block.Values = previousValue;
            block.UpdateData();
        }

        public override void Execute()
        {
            var block = FindBlock<ConstantBlockElement>(instanceIdentifier);

            block.UpdateBlockDefinition(newBlockDef);
            block.UpdateData();
        }
    }
}
