﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OperationManager.Core;

namespace EffectCombiner.Primitives.Operations
{
    public class AggregateOperation : OperationBase
    {
        private readonly List<IOperation> actions = new List<IOperation>();

        public AggregateOperation(OperationType displayName, params IOperation[] operation)
            : this(displayName, (IEnumerable<IOperation>)operation)
        {
        }

        public AggregateOperation(OperationType displayName, IEnumerable<IOperation> operations)
            : base(displayName.ToString())
        {
            AddRange(operations);
        }

        public void Add(IOperation operation)
        {
            if (operation == null)
                return;
            actions.Add(operation);
        }

        public void AddRange(IEnumerable<IOperation> operations)
        {
            if (operations == null)
                return;
            actions.AddRange(operations.Where(x => x != null));
        }

        public void Clear()
        {
            actions.Clear();
        }

        public override void Rollback()
        {
            foreach (var operation in actions.Reverse<IOperation>())
                operation.Rollback();
        }

        public override void Execute()
        {
            foreach (var operation in actions)
                operation.Execute();
        }
    }
}
