﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;

namespace EffectCombiner.Primitives
{
    public class MRUManager<T>
    {
        public MRUManager()
        {
            MaxItems = 10;
            recentlyUsedList = new List<T>(MaxItems);
            RecentlyUsed = new ReadOnlyCollection<T>(recentlyUsedList);
        }

        public void Initialize(IEnumerable<T> items)
        {
            recentlyUsedList.Clear();
            recentlyUsedList.AddRange(items);
        }

        public void IndicateAsUsed(T item)
        {
            recentlyUsedList.Remove(item);
            if (recentlyUsedList.Count >= MaxItems)
            {
                recentlyUsedList.RemoveRange(MaxItems - 1, recentlyUsedList.Count - MaxItems + 1);
            }
            recentlyUsedList.Insert(0, item);
        }

        private readonly List<T> recentlyUsedList;
        public IEnumerable<T> RecentlyUsed  { get; private set; }
        public int MaxItems { get; private set; }
    }
}
