﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;
using EffectCombiner.Primitives.Blocks;

namespace EffectCombiner.Primitives
{
    public class FakeBlockDefinition : BlockDefinition
    {
        public FakeBlockDefinition(BlockDefinition blockDefinition)
            : this(
            blockDefinition.Guid,
            blockDefinition.InputPlugs.Length,
            blockDefinition.OutputPlugs.Length)
        {
        }

        public FakeBlockDefinition(string guid, int inputPlugCount, int outputPlugCount)
            : base(
            null,
            Messages.TEXT_BLOCK_NAME_MISSING_BLOCK,
            guid,
            string.Empty,
            CreatePlugs(inputPlugCount, true),
            CreatePlugs(outputPlugCount, false),
            null,
            new PreviewDefinition())
        {
            // TODO: update block name at runtime
            //Globals.Localization.CultureChanged += (ss, ee) => Name = Messages.TEXT_MISSING_BLOCK;
        }

        private static ICollection<Plug> CreatePlugs(int count, bool isInput)
        {
            count = Math.Max(0, count);

            var plugs = new Plug[count];
            for (var i = 0; i < count; i++)
                plugs[i] = new Plug("?", new ShaderTypeDefinition("?"), "?", isInput, null, null);

            return plugs;
        }
    }
}
