﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectCombiner.Primitives;
using EffectCombiner.Primitives.Operations;
using OperationManager.Core;
using EffectCombiner.Core;

namespace EffectCombiner.Primitives
{
    public static class ExtendedOperationManager
    {
        private static CustomOperationManager _mainOperationManager;
        private static FileManagerBase fileManager;

        public static void Initialize(FileManagerBase fileManagerBase)
        {
            fileManager = fileManagerBase;
            fileManager.IsModifiedChanged += FileManagerIsModifiedChanged;

            _mainOperationManager = new CustomOperationManager();
            _mainOperationManager.OperationsAdded += MainOperationManagerOperationsAdded;
            _mainOperationManager.Undone += MainOperationManagerUndone;
            _mainOperationManager.Redone += MainOperationManagerRedone;

            lastSavedGuid = _mainOperationManager.AcquireCurrentGuid();

            Globals.SetMainOperationManager(_mainOperationManager);
        }

        private static void FileManagerIsModifiedChanged(object sender, EventArgs e)
        {
            if (fileManager.IsModified == false)
            {
                lastSavedGuid = _mainOperationManager.AcquireCurrentGuid();
            }
        }

        private static Guid lastSavedGuid;

        private static void ReevaluateModifiedFlag()
        {
            fileManager.IsModified = _mainOperationManager.IsCurrentGuid(lastSavedGuid) == false;
        }

        private static void MainOperationManagerOperationsAdded(object sender, OperationsEventArgs<OperationBase> e)
        {
            ReevaluateModifiedFlag();
        }

        private static void MainOperationManagerUndone(object sender, OperationEventArgs<OperationBase> e)
        {
            ReevaluateModifiedFlag();
        }

        private static void MainOperationManagerRedone(object sender, OperationEventArgs<OperationBase> e)
        {
            ReevaluateModifiedFlag();
        }
    }
}
