﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectCombiner.Primitives.Generation.Usage.Descriptors;

namespace EffectCombiner.Primitives.Generation.Usage
{
    public static class UsageManager
    {
        private static readonly IDictionary<string, IUsageDescriptor> usageDescriptors = new Dictionary<string, IUsageDescriptor>();

        static UsageManager()
        {
            AddUsageDescriptor(new ColorUsageDescriptor());
            AddUsageDescriptor(new TexCoordUsageDescriptor());
        }

        private static void AddUsageDescriptor(IUsageDescriptor usageDescriptor)
        {
            if (usageDescriptor == null)
                throw new ArgumentNullException("usageDescriptor");
            if (string.IsNullOrWhiteSpace(usageDescriptor.Name))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT_SUB, "usageDescriptor", "Name"), "usageDescriptor");

            usageDescriptors.Add(usageDescriptor.Name, usageDescriptor);
        }

        public static IUsageDescriptor GetUsageByName(string name)
        {
            if (string.IsNullOrWhiteSpace(name))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "name"), "name");

            IUsageDescriptor result;
            if (usageDescriptors.TryGetValue(name, out result) == false)
                return null;
            return result;
        }
    }
}
