﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation.Extensions
{
    public static class DefinitionExtensions
    {
        public static ParameterDefinition GetReturnAsParameter(this ShaderTyping.FunctionDefinition funcDef)
        {
            if (funcDef == null)
            {
                throw new ArgumentNullException("funcDef");
            }

            var betterFuncDef = funcDef as FunctionDefinition;
            if (betterFuncDef != null)
            {
                return new ParameterDefinition(
                    betterFuncDef.Source,
                    ParameterDefinition.ReturnParameterString,
                    new ShaderTypeDefinition(betterFuncDef.ReturnType.ToString()),
                    ShaderTyping.ParameterDirection.Output,
                    betterFuncDef.ReturnUsage,
                    betterFuncDef.ReturnDescription);
            }

            return new ParameterDefinition(
                null,
                ParameterDefinition.ReturnParameterString,
                new ShaderTypeDefinition(funcDef.ReturnType.ToString()),
                ShaderTyping.ParameterDirection.Output,
                null,
                null);
        }

        public static ShaderTyping.ShaderTypeDefinition[] GetInputParameterTypes(this ShaderTyping.FunctionDefinition funcDef)
        {
            if (funcDef == null)
            {
                throw new ArgumentNullException("funcDef");
            }

            return funcDef.Parameters
                .Where(p => p.Direction == ShaderTyping.ParameterDirection.Input)
                .Select(p => p.Type)
                .ToArray();
        }

        public static ShaderTyping.ShaderTypeDefinition[] GetOutputParameterTypes(this ShaderTyping.FunctionDefinition funcDef)
        {
            return funcDef.GetOutputParameterTypesEnumerable().ToArray();
        }

        public static IEnumerable<ShaderTyping.ShaderTypeDefinition> GetOutputParameterTypesEnumerable(this ShaderTyping.FunctionDefinition funcDef)
        {
            if (funcDef == null)
            {
                throw new ArgumentNullException("funcDef");
            }

            yield return funcDef.ReturnType;

            foreach (var p in funcDef.Parameters
                .Where(p => p.Direction == ShaderTyping.ParameterDirection.Output)
                .Select(p => p.Type))
            {
                yield return p;
            }
        }

        public static IEnumerable<FunctionDefinition> GetBoundFunctionDefinitions(this BlockDefinition blockDefinition)
        {
            if (blockDefinition == null)
            {
                throw new ArgumentNullException("blockDefinition");
            }

            return blockDefinition.FunctionBindings.Select(fb => fb.Definition).Where(fd => fd != null);
        }
    }
}
