﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectCombiner.Primitives.Generation
{
    #region UniformDataChangedEventArgs

    /// <summary>
    /// Uniform変数の変更イベントです。
    /// </summary>
    public class UniformDataChangedEventArgs : EventArgs
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="uniformName">Uniform変数名</param>
        /// <param name="oldValue">古い値</param>
        /// <param name="newValue">新しい値</param>
        public UniformDataChangedEventArgs(string uniformName, UniformData oldValue, UniformData newValue)
        {
            this.UniformName = uniformName;
            this.OldValue = (UniformData)oldValue?.Clone();
            this.NewValue = (UniformData)newValue?.Clone();
        }

        /// <summary>
        /// Uniform変数名を取得します。
        /// </summary>
        public string UniformName { get; private set; }

        /// <summary>
        /// 古い値を取得します。
        /// </summary>
        public UniformData OldValue { get; private set; }

        /// <summary>
        /// 新しい値を取得します。
        /// </summary>
        public UniformData NewValue { get; private set; }
    }

    #endregion

    #region ConstantValueChangedEventArgs

    /// <summary>
    /// constant 値の変更イベント情報です。
    /// </summary>
    public class ConstantValuesChangedEventArgs : EventArgs
    {
        /// <summary>
        /// ブロックエレメントを取得します。
        /// </summary>
        public ConstantBlockElement BlockElement { get; private set; }

        /// <summary>
        /// 元の値を取得します。
        /// </summary>
        public string[,] OldValue { get; private set; }

        /// <summary>
        /// 新しい値を取得します。
        /// </summary>
        public string[,] NewValue { get; private set; }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="blockElement">ブロックエレメント</param>
        /// <param name="oldValue"></param>
        /// <param name="newValue"></param>
        public ConstantValuesChangedEventArgs(ConstantBlockElement blockElement, string[,] oldValue, string[,] newValue)
        {
            this.BlockElement = blockElement;
            this.OldValue = oldValue;
            this.NewValue = newValue;
        }
    }

    #endregion
}
