﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using EffectDefinitions;
using Renderer2D.Core;

namespace EffectCombiner.Primitives.Generation
{
    public enum Connectability
    {
        None,
        Invalid,
        Good,
        Best,
        Unmatching,
    }

    public class BlockRenderInfo
    {
        public bool IsGraphInput { get; set; }
        public bool IsGraphOutput { get; set; }
        public bool IsSelected { get; set; }
        public bool IsInvertingSelection { get; set; }
        public bool IsDragging { get; set; }
        public bool IsPartOfCircularReference { get; set; }
        public bool IsUsable { get; set; }
        public IBitmap PreviewImage { get; set; }
        public bool[] PluggedInputs { get; set; }
        public bool[] PluggedOutputs { get; set; }
        public Connectability[] InputsConnectability { get; protected set; }
        public Connectability[] OutputsConnectability { get; protected set; }
        public PointF[] InputPlugPositions { get; set; }
        public PointF[] OutputPlugPositions { get; set; }

        public BlockRenderInfo()
        {
            IsUsable = true;
        }

        public void Initialize(BlockDefinition definition)
        {
            if (definition == null)
                throw new ArgumentNullException("definition");

            InputsConnectability = Enumerable.Repeat(Connectability.None, definition.InputPlugs.Length).ToArray();
            OutputsConnectability = Enumerable.Repeat(Connectability.None, definition.OutputPlugs.Length).ToArray();
        }
    }
}
