﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;
using ShaderGenerator.GLSL;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    // max, min に対する x の相対位置を [0, 1] の範囲で返すオペレータ（clamp アリ）。
    // ベクトルの入力については各要素ごとに上記の処理を行う
    public class LinearStepOperatorDefinitionSet : IAutoDefinitionSet
    {
        private static string MakeShaderCodeScalar(string funcName, string type, string[] paramNames)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2}, {0} {3}, {0} {4} )", type, funcName, paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    return ( clamp( {2}, {0}, {1} ) - {0} ) / ( {1} - {0} );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine("}");

            return sb.ToString();
        }
        private static string MakeShaderCodeVector2(string funcName, string type, string[] paramNames)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2}, {0} {3}, {0} {4} )", type, funcName, paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    {0} v;", type));
            sb.AppendLine(string.Format("    v.x = ( clamp( {2}.x, {0}.x, {1}.x ) - {0}.x ) / ( {1}.x - {0}.x );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    v.y = ( clamp( {2}.y, {0}.y, {1}.y ) - {0}.y ) / ( {1}.y - {0}.y );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    return v;"));
            sb.AppendLine("}");

            return sb.ToString();
        }
        private static string MakeShaderCodeVector3(string funcName, string type, string[] paramNames)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2}, {0} {3}, {0} {4} )", type, funcName, paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    {0} v;", type));
            sb.AppendLine(string.Format("    v.x = ( clamp( {2}.x, {0}.x, {1}.x ) - {0}.x ) / ( {1}.x - {0}.x );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    v.y = ( clamp( {2}.y, {0}.y, {1}.y ) - {0}.y ) / ( {1}.y - {0}.y );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    v.z = ( clamp( {2}.z, {0}.z, {1}.z ) - {0}.z ) / ( {1}.z - {0}.z );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    return v;"));
            sb.AppendLine("}");

            return sb.ToString();
        }
        private static string MakeShaderCodeVector4(string funcName, string type, string[] paramNames)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2}, {0} {3}, {0} {4} )", type, funcName, paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    {0} v;", type));
            sb.AppendLine(string.Format("    v.x = ( clamp( {2}.x, {0}.x, {1}.x ) - {0}.x ) / ( {1}.x - {0}.x );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    v.y = ( clamp( {2}.y, {0}.y, {1}.y ) - {0}.y ) / ( {1}.y - {0}.y );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    v.z = ( clamp( {2}.z, {0}.z, {1}.z ) - {0}.z ) / ( {1}.z - {0}.z );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    v.w = ( clamp( {2}.w, {0}.w, {1}.w ) - {0}.w ) / ( {1}.w - {0}.w );", paramNames[0], paramNames[1], paramNames[2]));
            sb.AppendLine(string.Format("    return v;"));
            sb.AppendLine("}");

            return sb.ToString();
        }

        public LinearStepOperatorDefinitionSet()
        {
            var paramNames = new[] { "min", "max", "x" };
            var supportedFunctionPrototypes = new[]
            {
                // 返り値, 引数1, 引数2, ...
                new[] { "int", "int", "int", "int" },
                new[] { "uint", "uint", "uint", "uint" },
                new[] { "float", "float", "float", "float" },
                new[] { "double", "double", "double", "double" },
                new[] { "vec2", "vec2", "vec2", "vec2" },
                new[] { "vec3", "vec3", "vec3", "vec3" },
                new[] { "vec4", "vec4", "vec4", "vec4" },
            };

            FunctionDefinitions = OperatorDefinitionSetUtility.CreateFunctions(this, supportedFunctionPrototypes, paramNames);
            BlockDefinition = new PolymorphicBlockDefinition(BlockName, Guid, FunctionDefinitions);

            ShaderCodes = new[]
            {
                MakeShaderCodeScalar( FunctionName, "int", paramNames ),       // int
                MakeShaderCodeScalar( FunctionName, "uint", paramNames ),      // uint
                MakeShaderCodeScalar( FunctionName, "float", paramNames ),     // float
                MakeShaderCodeScalar( FunctionName, "double", paramNames ),    // double
                MakeShaderCodeVector2( FunctionName, "vec2", paramNames ),     // vec2
                MakeShaderCodeVector3( FunctionName, "vec3", paramNames ),     // vec3
                MakeShaderCodeVector4( FunctionName, "vec4", paramNames ),     // vec4
            };
        }

        public string Guid
        {
            get { return "{277DAB85-7010-412E-83CA-BA9BA2204BB7}"; }
        }

        public string FunctionName
        {
            get { return "LinearStep"; }
        }

        public string BlockName
        {
            get { return "LinearStep"; }
        }

        public FunctionDefinition[] FunctionDefinitions { get; private set; }
        public PolymorphicBlockDefinition BlockDefinition { get; private set; }
        public string[] ShaderCodes { get; private set; }
    }
}
