﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;
using ShaderGenerator.GLSL;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class CrossProductOperatorDefinitionSet : IAutoDefinitionSet
    {
        private static string MakeShaderCode(string funcName, string type, string[] paramNames)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2}, {0} {3} )", type, funcName, paramNames[0], paramNames[1]));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    return cross( {0}, {1} );", paramNames[0], paramNames[1]));
            sb.AppendLine("}");

            return sb.ToString();
        }

        public CrossProductOperatorDefinitionSet()
        {
            var paramNames = new[] { "v1", "v2" };
            var supportedFunctionPrototypes = new[]
            {
                // 返り値, 引数1, 引数2, ...
                new[] { "vec3", "vec3", "vec3" },
                new[] { "dvec3", "dvec3", "dvec3" },
            };

            FunctionDefinitions = OperatorDefinitionSetUtility.CreateFunctions(this, supportedFunctionPrototypes, paramNames);
            BlockDefinition = new PolymorphicBlockDefinition(BlockName, Guid, FunctionDefinitions);

            ShaderCodes = new[]
            {
                MakeShaderCode( FunctionName, "vec3", paramNames ),     // vec3
                MakeShaderCode( FunctionName, "dvec3", paramNames ),    // dvec3
            };
        }

        public string Guid
        {
            get { return "{AB2DAE73-8A18-46DA-88A5-5EADDDC745F0}"; }
        }

        public string FunctionName
        {
            get { return "CrossProduct"; }
        }

        public string BlockName
        {
            get { return "CrossProduct"; }
        }

        public FunctionDefinition[] FunctionDefinitions { get; private set; }
        public PolymorphicBlockDefinition BlockDefinition { get; private set; }
        public string[] ShaderCodes { get; private set; }
    }
}
