﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public abstract class BuiltInFunctionDefinitionSet : IAutoDefinitionSet
    {
        protected BuiltInFunctionDefinitionSet(string functionName, string blockName,
            string guid,
            string[] parameterNames, string[][] functionPrototypes)
        {
            if (string.IsNullOrWhiteSpace(functionName))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "functionName"), "functionName");
            if (string.IsNullOrWhiteSpace(blockName))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "blockName"), "blockName");
            if (string.IsNullOrWhiteSpace(guid))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "guid"), "guid");

            FunctionName = functionName;
            BlockName = blockName;
            Guid = guid;

            FunctionDefinitions = OperatorDefinitionSetUtility.CreateFunctions(this, functionPrototypes, parameterNames);
            BlockDefinition = new PolymorphicBlockDefinition(BlockName, Guid, FunctionDefinitions);
            ShaderCodes = null;
        }

        public string Guid { get; private set; }
        public string FunctionName { get; private set; }
        public string BlockName { get; private set; }

        public PolymorphicBlockDefinition BlockDefinition { get; private set; }
        public FunctionDefinition[] FunctionDefinitions { get; private set; }
        public string[] ShaderCodes { get; private set; }
    }
}
