echo off

cd /d %~dp0

set SigloRoot=%2
set OutDir=%3

rem ---------------------------------------------------------------------------
rem Copy renderers to outputs
rem ---------------------------------------------------------------------------

set RENDERER2D_SRC_PATH=..\..\..\..\..\Outputs\AnyCPU\Tools\Graphics\EffectCombinerEditor\Lib\Renderer2D
cd "%RENDERER2D_SRC_PATH%"

set RENDERER2D_DST_PATH=..\..\App\Editor\%1\Renderers

if not exist "%RENDERER2D_DST_PATH%" (
    mkdir "%RENDERER2D_DST_PATH%"
)

rem Copy GDI Renderer
copy "Renderer2D.GDI\%1\Renderer2D.GDI.dll" "%RENDERER2D_DST_PATH%\"
if %1==Debug (
    copy "Renderer2D.GDI\%1\Renderer2D.GDI.pdb" "%RENDERER2D_DST_PATH%\"
)

rem Copy Direct2D Renderer
rem copy "Renderer2D.Direct2D1.WinForms\%1\SharpDX*.dll" "%RENDERER2D_DST_PATH%\"
rem copy "Renderer2D.Direct2D1.WinForms\%1\Renderer2D.*.dll" "%RENDERER2D_DST_PATH%\"
rem if %1==Debug (
rem     copy "Renderer2D.Direct2D1.WinForms\%1\Renderer2D.*.pdb" "%RENDERER2D_DST_PATH%\"
rem )

if %1==Debug (
    exit /b 0
)

rem ---------------------------------------------------------------------------
rem Copy results to %SigloRoot%\Tools
rem ---------------------------------------------------------------------------

set ResultDir="%SigloRoot%\Tools\Graphics\EffectCombinerEditor"

rd /s /q %ResultDir%

mkdir "%ResultDir%"

copy "%OutDir%\Blocks.Core.dll" "%ResultDir%\"
copy "%OutDir%\Communication.Contracts.dll" "%ResultDir%\"
copy "%OutDir%\Communication.Core.dll" "%ResultDir%\"
copy "%OutDir%\EffectCombiner.Core.dll" "%ResultDir%\"
copy "%OutDir%\EffectCombiner.Data.dll" "%ResultDir%\"
copy "%OutDir%\EffectCombiner.Generator.dll" "%ResultDir%\"
copy "%OutDir%\EffectCombiner.Primitives.dll" "%ResultDir%\"
copy "%OutDir%\EffectCombiner.Primitives.Generation.dll" "%ResultDir%\"
copy "%OutDir%\EffectCombinerEditor.exe" "%ResultDir%\"
copy "%OutDir%\EffectCombinerEditor.exe.config" "%ResultDir%\"
copy "%OutDir%\EffectDefinitions.dll" "%ResultDir%\"
copy "%OutDir%\FontAwesome.WPF.dll" "%ResultDir%\"
copy "%OutDir%\Nintendo.ToolFoundation.dll" "%ResultDir%\"
copy "%OutDir%\Nintendo.ToolFoundation.Windows.dll" "%ResultDir%\"
copy "%OutDir%\Nintendo.ToolFoundation.WPF.dll" "%ResultDir%\"
copy "%OutDir%\OperationManager.Core.dll" "%ResultDir%\"
copy "%OutDir%\Renderer2D.Core.dll" "%ResultDir%\"
copy "%OutDir%\Renderer2D.Core.WinForms.dll" "%ResultDir%\"
copy "%OutDir%\ShaderGenerator.CafeCompiler.dll" "%ResultDir%\"
copy "%OutDir%\ShaderGenerator.Core.dll" "%ResultDir%\"
copy "%OutDir%\ShaderGenerator.GLSL.dll" "%ResultDir%\"
copy "%OutDir%\ShaderTyping.dll" "%ResultDir%\"
copy "%OutDir%\System.Interactive.dll" "%ResultDir%\"
copy "%OutDir%\System.Windows.Interactivity.dll" "%ResultDir%\"
copy "%OutDir%\ToolFoundation.dll" "%ResultDir%\"
copy "%OutDir%\ToolFoundation.xml" "%ResultDir%\"
copy "%OutDir%\WeifenLuo.WinFormsUI.Docking.dll" "%ResultDir%\"
copy "%OutDir%\Workflow.Core.dll" "%ResultDir%\"

mkdir "%ResultDir%\Renderers"

rem Copy GDI renderer
copy "%OutDir%\Renderers\Renderer2D.GDI.dll" "%ResultDir%\Renderers\"

rem Copy Direct2D Renderer
rem copy "%OutDir%\Renderers\SharpDX*.dll" "%ResultDir%\Renderers\"
rem copy "%OutDir%\Renderers\Renderer2D.*.dll" "%ResultDir%\Renderers\"
