﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace EffectCombiner.Generator
{
    public static class Utility
    {
        public static string UsePath(string relativePath)
        {
            var assemblyPath = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location);
            var absolutePath = string.Format("{0}\\{1}", assemblyPath, relativePath);

            if (Directory.Exists(absolutePath) == false)
                Directory.CreateDirectory(absolutePath);

            return absolutePath;
        }

        public static string[] EnsurePatterns(string[] patterns, params string[] defaultPattern)
        {
            if (patterns != null && patterns.Length > 0)
                return patterns;
            return defaultPattern;
        }
    }
}
