﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using EffectCombiner.Core;
using EffectCombiner.Primitives.Generation;
using EffectDefinitions;

namespace EffectCombiner.Generator
{
    public class CustomEffectDefinitionsContainer : EffectDefinitionsContainer
    {
        public IContentRepository ContentRepository { get; private set; }

        public CustomEffectDefinitionsContainer()
        {
            ContentRepository = new CustomContentRepository(CacheMode.Compressed);
        }

        protected override string GetRawContent(string filePath, Encoding encoding)
        {
            return ContentRepository.GetContent(new Uri(filePath), encoding);
        }
    }
}
