﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using System.Windows.Forms;
using EffectCombiner.Primitives;

namespace EffectCombiner.Editor.OptionPanes
{
    /// <summary>
    /// 定義パスリスト設定ペインです。
    /// </summary>
    public partial class DefinitionPathListPane : UserControl, IOptionPane
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public DefinitionPathListPane()
        {
            InitializeComponent();

            var localizationSubscription = Globals.Localization.RegisterLocalization(() =>
                {
                    btnAddDefinitionsPath.Text = Localization.Controls.OPTION_PANE_DEFINITION_PATH_ADD_BUTTON;
                    chkReloadDefinitionsOnPathChange.Text = Localization.Controls.OPTION_PANE_DEFINITION_PATH_AUTO_RELOAD_CHECKBOX;
                });

            Disposed += (ss, ee) => localizationSubscription.Dispose();
        }

        /// <summary>
        /// オプションペインの識別名を取得します。
        /// </summary>
        public string DisplayName { get { return Localization.Controls.OPTION_PANE_NAME_DEFINITIONS; } }

        /// <summary>
        /// このオプションペインの親ノードになるペインの識別名を取得します。
        /// ルートペインのときはnullを返します。
        /// </summary>
        public string ChildOf { get { return null; } }

        /// <summary>
        /// オプションダイアログに表示するノード名を取得します。
        /// </summary>
        public string Identifier { get { return "PathListPane"; } }

        /// <summary>
        /// オプションペインを生成したときの処理を行います。
        /// </summary>
        public void OnInitialize()
        {
            if (Globals.Options.DefinitionPaths == null ||
                Globals.Options.DefinitionPaths.Paths == null)
            {
                return;
            }

            this.lstDefinitionPath.SetDefinitionPaths(Globals.Options.DefinitionPaths.Paths);
            this.chkReloadDefinitionsOnPathChange.Checked = Globals.Options.DefinitionPaths.ReloadDefinitionsOnPathChange;
        }

        /// <summary>
        /// オプションダイアログを閉じたときの処理を行います。
        /// </summary>
        public void OnTerminate()
        {
            foreach (var item in lstDefinitionPath.ListView.Items.Cast<PathInfoListViewItem>())
            {
                item.Dispose();
            }
        }

        /// <summary>
        /// オプションダイアログのOKボタンを押したときの処理を行います。
        /// </summary>
        public void OnAccept()
        {
            if (Globals.Options.DefinitionPaths == null)
            {
                Globals.Options.DefinitionPaths = new DefinitionPathInfos();
            }

            Globals.Options.DefinitionPaths.Paths = this.lstDefinitionPath.GetDefinitionPaths();
            Globals.Options.DefinitionPaths.ReloadDefinitionsOnPathChange = chkReloadDefinitionsOnPathChange.Checked;
        }

        /// <summary>
        /// オプションダイアログのキャンセルボタンを押したときの処理を行います。
        /// </summary>
        public void OnCancel()
        {
        }

        /// <summary>
        /// 定義パスの追加ボタンを押したときの処理を行います。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void btnAddDefinitionsPath_Click(object sender, EventArgs e)
        {
            this.lstDefinitionPath.AddOrEditDefinitionPath(true);
        }
    }
}
