﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml.Serialization;

namespace EffectCombiner.Data.Processors.Version1
{
    [Serializable]
    public class BlockV1
    {
        [XmlAttribute("id")]
        public string Identifier;
        [XmlAttribute("guid")]
        public string BlockGuid;
        [XmlAttribute("x")]
        public float PositionX;
        [XmlAttribute("y")]
        public float PositionY;
    }

    [Serializable]
    public class BlocksV1
    {
        [XmlElement("block")]
        public BlockV1[] Block;
    }

    [Serializable]
    public class BlockReferenceV1
    {
        [XmlAttribute("block")]
        public string BlockIdentifier;
        [XmlAttribute("index")]
        public int PlugIndex;
    }

    [Serializable]
    public class ConnectionV1
    {
        [XmlElement("source")]
        public BlockReferenceV1 Source;
        [XmlElement("target")]
        public BlockReferenceV1 Target;
    }

    [Serializable]
    public class ConnectionsV1
    {
        [XmlElement("connection")]
        public ConnectionV1[] Connection;
    }

    [Serializable, XmlRoot("project")]
    public class ProjectV1
    {
        [XmlAttribute("version")]
        public ushort Version;
        [XmlAttribute("x")]
        public float WorkspacePositionX;
        [XmlAttribute("y")]
        public float WorkspacePositionY;
        [XmlElement("blocks")]
        public BlocksV1 Blocks;
        [XmlElement("connections")]
        public ConnectionsV1 Connections;
    }
}
