﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace EffectCombiner.Data
{
    public class WorkflowDataEventReport
    {
        public Func<string> Message;
        public bool IsError;
        public Exception Exception;
    }

    public interface IWorkflowDataEventReporter
    {
        void Report(WorkflowDataEventReport eventReport);
    }

    // ==================================================================================

    public interface IWorkflowProcessor
    {
        ushort Version { get; }
        void SetReporter(IWorkflowDataEventReporter reporter);
        object Load(Stream input);
        void Save(Stream output, object workflow);
    }

    public interface IWorkflowConverter
    {
        ushort SourceVersion { get; }
        ushort TargetVersion { get; }
        object Convert(object sourceWorkflowData);
    }
}
