﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// nps ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace nps {

//=============================================================================
//! @brief スライス情報のクラスです。
//=============================================================================
class RSliceInfo
{
  public:
    int m_Index; //!< インデックスです。
    std::string m_Name; //!< 名前です。
    std::string m_IndexName; //!< インデックスから決定した名前です。
    std::string m_ZeroBasedName; //!< 0 起算のインデックスから決定した名前です。
    int m_X; //!< 左上の X 座標です。
    int m_Y; //!< 左上の Y 座標です。
    int m_W; //!< 幅です。
    int m_H; //!< 高さです。
    bool m_IsUser; //!< ユーザー定義スライスなら true です。
    bool m_IsImage; //!< 画像ありなら true です。
    bool m_IsDivided; //!< 前面にある他のスライスによって分割されているなら true です。
    bool m_IsDefaultName; //!< インデックスから決定した名前を使用するなら true です。

  public:
    //! @brief コンストラクタです。
    RSliceInfo(const int sliceIdx, const int x, const int y, const int w, const int h, const char* name)
    : m_Index(sliceIdx),
      m_X(x),
      m_Y(y),
      m_W(w),
      m_H(h),
      m_IsUser(true),
      m_IsImage(true),
      m_IsDivided(false)
    {
        m_IsDefaultName = (name == NULL || name[0] == 0);
        SetIndexName();
        m_Name = (m_IsDefaultName) ? m_IndexName : name;
    }

    //! @brief インデックスから名前を設定します。
    void SetIndexName()
    {
        m_IndexName = RGetNumberString(m_Index, "%02d");
        m_ZeroBasedName = RGetNumberString(RMax(m_Index - 1, 0), "%02d");
    }

    //! @brief デバッグ用の文字列を返します。
    std::string GetString(void) const;
};

//! @brief スライス情報配列の定義です。
typedef std::vector<RSliceInfo> RSliceInfoArray;

//=============================================================================
// スライス関連の関数です。
//=============================================================================

//! @brief スライス情報配列を取得します。
//!
//! @param[out] infos スライス情報配列を格納します。
//! @param[in] isImageOnly 画像のあるスライスのみ取得するなら true を指定します。
//! @param[in] cutPrefix スライス名の先頭から削除する文字列です。
//!
void RGetSliceInfos(
    RSliceInfoArray& infos,
    const bool isImageOnly,
    const std::string& cutPrefix
);

//=============================================================================
// nps ネームスペースを終了します。
//=============================================================================
} // namespace nps
} // namespace tool
} // namespace gfx
} // namespace nn

