﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// RWriteLittle RWriteBig RReadLittle RReadBig

//=============================================================================
// nps ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace nps {

/******************************************************************************
    write little endian
******************************************************************************/
template <typename T>
void RWriteLittle(GPtr globals, T value)
{
    if (gResult != noErr)
    {
        return;
    }

    uint8_t* top = reinterpret_cast<uint8_t*>(&value);
    #ifdef __PIMac__
    // swap
    uint8_t* p1 = top;
    uint8_t* p2 = p1 + sizeof(T) - 1;
    int byteSizeHalf = sizeof(T) / 2;
    for (int ibyte = 0; ibyte < byteSizeHalf; ++ibyte, ++p1, --p2)
    {
        RSwapValue(*p1, *p2);
    }
    #endif

    int32 writeCount = sizeof(T);
    gResult = FSWrite(static_cast<int>(gStuff->dataFork), &writeCount, top);
    if (gResult == noErr && writeCount != sizeof(T))
    {
        gResult = dskFulErr;
    }
}

/******************************************************************************
    write big endian
******************************************************************************/
template <typename T>
void RWriteBig(GPtr globals, T value)
{
    if (gResult != noErr)
        return;

    uint8_t* top = reinterpret_cast<uint8_t*>(&value);
    #ifdef __PIWin__
    // swap
    uint8_t* p1 = top;
    uint8_t* p2 = p1 + sizeof(T) - 1;
    int byteSizeHalf = sizeof(T) / 2;
    for (int ibyte = 0; ibyte < byteSizeHalf; ++ibyte, ++p1, --p2)
    {
        RSwapValue(*p1, *p2);
    }
    #endif

    int32 writeCount = sizeof(T);
    gResult = FSWrite(gStuff->dataFork, &writeCount, top);
    if (gResult == noErr && writeCount != sizeof(T))
    {
        gResult = dskFulErr;
    }
}

/******************************************************************************
    read little endian
******************************************************************************/
template <typename T>
void RReadLittle(GPtr globals, T& value)
{
    if (gResult != noErr)
    {
        return;
    }

    int32 readCount = sizeof(T);
    gResult = FSRead(gStuff->dataFork, &readCount, &value);
    if (gResult == noErr && readCount != sizeof(T))
    {
        gResult = dskFulErr;
    }

    #ifdef __PIMac__
    // swap
    uint8_t* p1 = reinterpret_cast<uint8_t*>(&value);
    uint8_t* p2 = p1 + sizeof(T) - 1;
    int byteSizeHalf = sizeof(T) / 2;
    for (int ibyte = 0; ibyte < byteSizeHalf; ++ibyte, ++p1, --p2)
    {
        RSwapValue(*p1, *p2);
    }
    #endif
}

/******************************************************************************
    read big endian
******************************************************************************/
template <typename T>
void RReadBig(GPtr globals, T& value)
{
    if (gResult != noErr)
    {
        return;
    }

    int32 readCount = sizeof(T);
    gResult = FSRead(gStuff->dataFork, &readCount, &value);
    if (gResult == noErr && readCount != sizeof(T))
    {
        gResult = dskFulErr;
    }

    #ifdef __PIWin__
    // swap
    uint8_t* p1 = reinterpret_cast<uint8_t*>(&value);
    uint8_t* p2 = p1 + sizeof(T) - 1;
    int byteSizeHalf = sizeof(T) / 2;
    for (int ibyte = 0; ibyte < byteSizeHalf; ++ibyte, ++p1, --p2)
    {
        RSwapValue(*p1, *p2);
    }
    #endif
}

//=============================================================================
// nps ネームスペースを終了します。
//=============================================================================
} // namespace nps
} // namespace tool
} // namespace gfx
} // namespace nn

