﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// include
//=============================================================================
#include "PIDefines.h"
#include "PIActions.h"
#include "PITerminology.h"
#include "NpsFormatCommand.h"

#ifndef Rez
    #include "NintendoFtx.h"
#endif

//=============================================================================
// constants
//=============================================================================
#define vendorName          "Nintendo"
#define plugInName          "Nintendo ftx"
#define plugInAETEComment   "Nintendo ftx Format Plugin"

#define plugInSuiteID       'nwfP'
#define plugInClassID       'fTx '
#define plugInEventID       typeNull // must be this
#define plugInUniqueID      "4DD0C29F-80F3-4137-B348-BC311DF3E117"

#define plugInCopyrightYear "2018"
#define plugInDescription \
    "Nintendo ftx Format Plugin for Adobe Photoshop."

#define keyPreviewFlag      'preV' // registry

//=============================================================================
// functions
//=============================================================================
#ifndef Rez
//-----------------------------------------------------------------------------
// read phase
OSErr ReadScriptParamsOnRead(GPtr globals);
OSErr WriteScriptParamsOnRead(GPtr globals);

//-----------------------------------------------------------------------------
// write phase
OSErr ReadScriptParamsOnWrite(GPtr globals);
OSErr WriteScriptParamsOnWrite(GPtr globals);
#endif

