﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// ReadScriptParamsOnRead  WriteScriptParamsOnRead
// ReadScriptParamsOnWrite WriteScriptParamsOnWrite

//=============================================================================
// include
//=============================================================================
#include "NintendoFtxScripting.h"

#include "NpsFormatScripting.cpp"
#include "NpsFormatRegistry.cpp"

using namespace nn::gfx::tool::nps;

//-----------------------------------------------------------------------------
//! @brief ftx ファイルリード時のスクリプトパラメータをリードします。
//!
//! @param[in,out] globals グローバルデータです。
//!
//! @return エラーコードを返します。
//-----------------------------------------------------------------------------
OSErr ReadScriptParamsOnRead(GPtr globals)
{
    OSErr error = noErr;

    R_UNUSED_VARIABLE(globals);

    return error;
}

//-----------------------------------------------------------------------------
//! @brief ftx ファイルリード時のスクリプトパラメータをライトします。
//!
//! @param[in] globals グローバルデータです。
//!
//! @return エラーコードを返します。
//-----------------------------------------------------------------------------
OSErr WriteScriptParamsOnRead(GPtr globals)
{
    OSErr error = noErr;

    R_UNUSED_VARIABLE(globals);

    return error;
}

//-----------------------------------------------------------------------------
//! @brief ftx ファイルライト時のスクリプトパラメータをリードします。
//!
//! @param[in,out] globals グローバルデータです。
//!
//! @return エラーコードを返します。
//-----------------------------------------------------------------------------
OSErr ReadScriptParamsOnWrite(GPtr globals)
{
    OSErr error = noErr;

    error = RReadFormatScriptParams(globals);

    return error;
}

//-----------------------------------------------------------------------------
//! @brief ftx ファイルライト時のスクリプトパラメータをライトします。
//!
//! @param[in] globals グローバルデータです。
//!
//! @return エラーコードを返します。
//-----------------------------------------------------------------------------
OSErr WriteScriptParamsOnWrite(GPtr globals)
{
    OSErr error = noErr;

    error = RWriteFormatScriptParams(globals);

    return error;
}

