﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// Globals

//=============================================================================
// include
//=============================================================================
#include "NpsFormat.h"

//=============================================================================
// constants
//=============================================================================

//-----------------------------------------------------------------------------
// plugin name & help
#define NPS_PLUGIN_NAME "NintendoFtx"
#define NPS_PLUGIN_DESCRIPTION "ftx Format Plugin"
#define NPS_PLUGIN_HELP_URL "html/NW4F_ftx.html"

//=============================================================================
//! @brief グローバルデータのクラスです。
//=============================================================================
class Globals
{
public:
    // format common
    int16* result;                  // Must always be first in Globals.
    FormatRecord* formatParamBlock; // Must always be second in Globals.
    bool queryForParameters;

    // buffer
    uint8_t* m_pBitmapData; //!< リード／ライト時に Photoshop 上のビットマップデータを格納するバッファです。

    // info
    nn::gfx::tool::nps::RAddInfo* m_pAddInfo; //!< 付加情報のポインタです。
    nn::gfx::tool::nps::RImageStatus* m_pImageStatus; //!< 画像状態のポインタです。

    // preview
    bool m_DisplaysPreview; //!< プレビューを表示するなら true です。
    bool m_PreviewDataSetFlag; //!< プレビューでデータ設定済みなら true です。
    nn::gfx::tool::nps::FtxFormat m_PreviewFormat; //!< プレビューで表示したフォーマットです。
    uint8_t* m_pPreviewBitmap; //!< プレビュー用ビットマップデータを格納するバッファです。

    // texcvtr
    nn::gfx::tool::nps::RTexCvtr* m_pTexCvtr; //!< 3D テクスチャーコンバーターへのポインターです。

public:
    //! コンストラクタです。
    Globals()
    {
        //nn::gfx::tool::nps::RNoteTrace("Globals()");
        queryForParameters = false;

        m_pBitmapData = NULL;

        m_pAddInfo = NULL;
        m_pImageStatus = NULL;

        m_DisplaysPreview = false;
        m_PreviewDataSetFlag = false;
        m_pPreviewBitmap = NULL;

        m_pTexCvtr = nullptr;
    }

    // デストラクタを仮想デストラクタにすると PluginMain の最後の PIUnlockHandle で例外が発生するので注意。
    //~Globals()
    //{
    //  //RNoteTrace("~Globals()");
    //}

    //! ビットマップデータを解放します。
    void FreeBitmapData()
    {
        nn::gfx::tool::nps::RFreeAndClearArray(m_pBitmapData);
    }

    //! 付加情報を解放します。
    void FreeAddInfo()
    {
        nn::gfx::tool::nps::RFreeAndClearObject(m_pAddInfo);
    }

    //! 画像状態を解放します。
    void FreeImageStatus()
    {
        nn::gfx::tool::nps::RFreeAndClearObject(m_pImageStatus);
    }

    //! プレビュー用ビットマップを解放します。
    void FreePreviewBitmap()
    {
        nn::gfx::tool::nps::RFreeAndClearArray(m_pPreviewBitmap);
    }

    //! 3D テクスチャーコンバーターを解放します。
    void FreeTexConverter()
    {
        nn::gfx::tool::nps::RFreeAndClearObject(m_pTexCvtr);
    }
};

typedef Globals* GPtr;
typedef Globals** GHdl;
typedef void (*FProc)(GPtr globals);

// format common
#define gResult (*(globals->result))       // SDK のマクロのため、かならず gResult という名前で定義します。
#define gStuff (globals->formatParamBlock) // SDK のマクロのため、かならず gStuff  という名前で定義します。
#define gQueryForParameters (globals->queryForParameters)

// ftx format
#define g_AddInfo (*globals->m_pAddInfo)
#define g_ImageStatus (*globals->m_pImageStatus)

//=============================================================================
// include after Globals
//=============================================================================
#include "NpsFormatFunction.h"

