/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//=============================================================================
// include
//=============================================================================
#ifdef __POWERPC__
    #if TARGET_CARBON
        #include "PIRezMacCarbon.h"
    #else
        #include "PIRezMac.h"
    #endif
    #define PRAGMA_ONCE 0
#else
    #define Rez 1
#endif

#include "PIDefines.h"
#include "PIActions.h"

#include "NintendoDistanceFieldScripting.h"

#ifdef __PIWin__
    #include "PIGeneral.h"
    #include "PIUtilities.r"
    #if (PS_API_VERSION <= 900)
        #include "WinDialogUtils.r"
    #endif
#elif defined(__PIMac__)
    #include "Types.r"
    #include "SysTypes.r"
    #include "PIGeneral.r"
    #include "PIUtilities.r"
    #if (PS_API_VERSION <= 900)
        #include "DialogUtilities.r"
    #endif
#endif

//=============================================================================
// PiPL resource
//=============================================================================
resource 'PiPL' (ResourceID, plugInName " PiPL", purgeable)
{
    {
        Kind { Filter },
        Name { plugInName "..." },
        Category { vendorName },
        Version { (latestFilterVersion << 16 ) | latestFilterSubVersion },

        #ifdef __PIWin__
            #if defined(_WIN64)
                CodeWin64X86 { "PluginMain" },
            #else
                CodeWin32X86 { "PluginMain" },
            #endif
        #elif TARGET_CARBON
            CodeCarbonPowerPC { 0, 0, "" },
        #else
            CodePowerPC { 0, 0, "" },
        #endif

        // ClassID, eventID, aete ID, uniqueString:
        HasTerminology { plugInClassID, plugInEventID, ResourceID, plugInUniqueID },

        SupportedModes
        {
            noBitmap,
            doesSupportGrayScale,
            noIndexedColor,
            doesSupportRGBColor,
            noCMYKColor,
            noHSLColor,
            noHSBColor,
            noMultichannel,
            noDuotone,
            noLABColor
        },
        EnableInfo { "in (PSHOP_ImageMode, GrayScaleMode, RGBMode)" },

        FilterCaseInfo
        {
            {
                /* Flat data, no selection */
                inStraightData, outStraightData,
                doNotWriteOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Flat data with selection */
                inStraightData, outStraightData,
                //doNotWriteOutsideSelection, // autoMask L
                writeOutsideSelection, // autoMask 
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Floating selection */
                inStraightData, outStraightData,
                writeOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Editable transparency, no selection */
                inStraightData, outStraightData,
                doNotWriteOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Editable transparency, with selection */
                inStraightData, outStraightData,
                writeOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Preserved transparency, no selection */
                inStraightData, outStraightData,
                doNotWriteOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Preserved transparency, with selection */
                inStraightData, outStraightData,
                writeOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination
            }
        }
    }
};

//=============================================================================
// dictionary (scripting) resource
//=============================================================================
resource 'aete' (ResourceID, plugInName " dictionary", purgeable)
{
    1, 0, english, roman,                                   /* aete version and language specifiers */
    {
        vendorName,                                         /* vendor suite name */
        "Distance Field Filter",                            /* optional description */
        plugInSuiteID,                                      /* suite ID */
        1,                                                  /* suite code, must be 1 */
        1,                                                  /* suite level, must be 1 */
        {                                                   /* structure for filters */
            plugInName,                                     /* unique filter name */
            plugInAETEComment,                              /* optional description */
            plugInClassID,                                  /* class ID, must be unique or Suite ID */
            plugInEventID,                                  /* event ID, must be unique to class ID */

            NO_REPLY,                                       /* never a reply */
            IMAGE_DIRECT_PARAMETER,                         /* direct parameter, used by Photoshop */
            {                                               /* parameters here, if any */
                "Max Distance",                             /* parameter name */
                nnDistanceFieldKeyMaxDistance,              /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "max distance",                             /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Edge Wrap",                                /* parameter name */
                nnDistanceFieldKeyEdgeWrap,                 /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "edge wrap",                                /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Normalize",                                /* parameter name */
                nnDistanceFieldKeyNormalize,                /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "normalize",                                /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */
            }
        },
        {                                                   /* non-filter plug-in class here */
        },
        {                                                   /* comparison ops (not supported) */
        },
        {                                                   /* any enumerations */
        }
    }
};

