﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/******************************************************************************
    include
******************************************************************************/
#include "DccUtilityLight.h"

namespace Dcc = nn::gfx::tool::dcc;

/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {

float RLight::mMagnify = 1.0f;

//----------------------------------------------------------------------------
// コンストラクタ
RLight::RLight()
: mLightKind(Directional)
, mIsDistAttnAnimEnable( false )
{
}

//----------------------------------------------------------------------------
//	ライトのアニメーションの出力準備をします。
void RLight::PrepareAnimations( const Dcc::RExpOpt& rOpt )
{
    /*
    const float baseValues[RLight::kAttrMax] =
    {
        (float)RRoundToZero((mIsBranchVisible) ? 1.0f : 0.0f),
        (float)RRoundToZero(mScale.x),
        (float)RRoundToZero(mScale.y),
        (float)RRoundToZero(mScale.z),
        (float)RRoundToZero(mRotate.x),
        (float)RRoundToZero(mRotate.y),
        (float)RRoundToZero(mRotate.z),
        (float)RRoundToZero(mTranslate.x),
        (float)RRoundToZero(mTranslate.y),
        (float)RRoundToZero(mTranslate.z),
        (float)RRoundToZero(mAmbient.x),
        (float)RRoundToZero(mAmbient.y),
        (float)RRoundToZero(mAmbient.z),
        (float)RRoundToZero(mAmbient.w),
        (float)RRoundToZero(mDiffuse.x),
        (float)RRoundToZero(mDiffuse.y),
        (float)RRoundToZero(mDiffuse.z),
        (float)RRoundToZero(mDiffuse.w),
        (float)RRoundToZero(mSpecular0.x),
        (float)RRoundToZero(mSpecular0.y),
        (float)RRoundToZero(mSpecular0.z),
        (float)RRoundToZero(mSpecular0.w),
        (float)RRoundToZero(mSpecular1.x),
        (float)RRoundToZero(mSpecular1.y),
        (float)RRoundToZero(mSpecular1.z),
        (float)RRoundToZero(mSpecular1.w),
        (float)RRoundToZero(mDirection.x),
        (float)RRoundToZero(mDirection.y),
        (float)RRoundToZero(mDirection.z)
    };
    */

    //=============================================================================
    //	AnalyzeLightFullAnim
    //=============================================================================
    //-----------------------------------------------------------------------------
    // backup original rotate values
    /*
    mAnims[kRx].mOrgFullValues = mAnims[kRx].mFullValues;
    mAnims[kRy].mOrgFullValues = mAnims[kRy].mFullValues;
    mAnims[kRz].mOrgFullValues = mAnims[kRz].mFullValues;

    //-----------------------------------------------------------------------------
    // make rotate continuous
    if (RMakeContinuousXyzAngleArray(
        mAnims[kRx].mFullValues,
        mAnims[kRy].mFullValues,
        mAnims[kRz].mFullValues,
        true)) // degreeFlag
    {
        #ifdef DEBUG_PRINT_SW
        gErr << "rotate made continuous: " << mOrgName << R_ENDL;
        #endif
    }
    */

    for (int iattr = 0; iattr < Dcc::RLight::PARAM_COUNT; ++iattr)
    {
        //-----------------------------------------------------------------------------
        // set curve name & loop flag & angle flag
        Dcc::RAnimCurve& curve = mAnims[iattr];

        curve.m_Name = mName + "." + Dcc::RLight::GetParamName(iattr);
        curve.m_LoopFlag = rOpt.m_LoopAnim;
        curve.m_AngleFlag = Dcc::RLight::IsRotate(iattr);

        //-----------------------------------------------------------------------------
        // set tolerance
        # if 1 //#ifdef OPTIMIZE_VECTOR_BY_TOL_R
        if (Dcc::RLight::IsVector(iattr))
        {
            if (iattr == Dcc::RLight::DIRECTION_X)
            {
                Dcc::RUpdateVectorAnimConstantFlag(
                    curve, mAnims[iattr + 1], mAnims[iattr + 2], rOpt.m_TolR);
            }
            continue;
        }
        #endif

        if (Dcc::RLight::IsTranslate(iattr))
        {
            // mTolT は Magnify を掛ける前の値に対する許容値なので
            // Magnify を掛ける
            //	TODO :
            //curve.mTolerance = (float)(gOpts.mTolT * gOpts.mMagnify);
            curve.m_Tolerance = rOpt.m_TolT;
        }
        else if (Dcc::RLight::IsColor(iattr))
        {
            curve.m_Tolerance = rOpt.m_TolC;
        }
        else // kVis
        {
            curve.m_Tolerance = Dcc::R_MAKE_KEY_TOL_LIGHT_OTHER;
        }

        /*
        if( curve.IsKeyUpdated() )
        {
            continue;
        }
        */

        //-----------------------------------------------------------------------------
        // check constant
        //curve.UpdateConstantFlag();
    }

    //=============================================================================
    //	GetLightKeyAnim
    //=============================================================================
    //-----------------------------------------------------------------------------
    // loop for lit attr
    for (int iattr = 0; iattr < Dcc::RLight::PARAM_COUNT; ++iattr)
    {
        //-----------------------------------------------------------------------------
        // get channel input
        Dcc::RAnimCurve& curve = mAnims[iattr];

        /*
        {
            if(IsScaleAttr(iattr) && mForceExportScaleKey)
            {
                //curve.mUseFlag = true;
                if( curve.mFullValues.size() == 0 )
                {
                    curve.mFullValues.push_back( mScale[iattr - kSx] );
                }
            }
            if(IsRotateAttr(iattr) && mForceExportRotateKey)
            {
                //curve.mUseFlag = true;
                if( curve.mFullValues.size() == 0 )
                {
                    curve.mFullValues.push_back( mRotate[iattr - kRx] );
                }
            }
            if(IsTranslateAttr(iattr) && mForceExportTransKey)
            {
                //curve.mUseFlag = true;
                if( curve.mFullValues.size() == 0 )
                {
                    curve.mFullValues.push_back( mTranslate[iattr - kTx] );
                }
            }
            if(IsVectorAttr(iattr) && mForceExportRotateKey)
            {
                //curve.mUseFlag = true;
                if( curve.mFullValues.size() == 0 )
                {
                    curve.mFullValues.push_back( mDirection[iattr - kDx] );
                }
            }
        }
        */

        //-----------------------------------------------------------------------------
        // set use flag

        /*
        if (IsScaleAttr(iattr))
        {
            if(!curve.mConstantFlag)
            {	mUseAnimFlagS = true;	}
            if(!mForceExportScaleKey)
            {	curve.UpdateUseFlag(baseValues[iattr]);	}
        }
        else if (IsRotateAttr(iattr))
        {
            if(!curve.mConstantFlag)
            {
                //mUseAnimFlagR = true;
            }
        }
        else if (IsTranslateAttr(iattr))
        {
            if(!curve.mConstantFlag)
            {	mUseAnimFlagT = true;}
            if(!mForceExportTransKey)
            {	curve.UpdateUseFlag(baseValues[iattr]);	}
        }
        else if (IsVectorAttr(iattr))
        {
            if(!curve.mConstantFlag)
            {	mUseAnimFlagD = true;}
            if(!mForceExportRotateKey)
            {	curve.UpdateUseFlag(baseValues[iattr]);	}
        }
        else
        {
            if(curve.mFullValues.size() > 0)
            {
                if (IsAmbientColAttr(iattr))
                {	mUseAnimFlagA = true;}
                else if (kAa == iattr)
                {	mUseAnimFlagAA = true;}
                else if (IsDiffuseColAttr(iattr))
                {	mUseAnimFlagC = true;}
                else if (kDa == iattr)
                {	mUseAnimFlagCA = true;}
                else if (IsSpecular0ColAttr(iattr))
                {	mUseAnimFlagS0 = true;}
                else if (kS0a == iattr)
                {	mUseAnimFlagS0A = true;}
                else if (IsSpecular1ColAttr(iattr))
                {	mUseAnimFlagS1 = true;}
                else if (kS1a == iattr)
                {	mUseAnimFlagS1A = true;}
            }
            else
            {
                curve.mUseFlag = false;
            }
        }

        if( curve.IsKeyUpdated() )
        {
            continue;
        }
        */

        //-----------------------------------------------------------------------------
        if ( curve.m_Keys.empty() )
        {
            if (iattr == Dcc::RLight::ENABLE)
            {
                // enable は step カーブ
                curve.MakeStepKeys(GetFloatFrameFromSubFrame4f, nullptr);
            }
            else
            {
                curve.MakeKeys(GetFloatFrameFromSubFrame4f, nullptr, IsRotateAttr(iattr));
            }

            curve.UpdateConstantFlag();
        }

        curve.UpdateUseFlag( curve.m_Tolerance );
        //curve.m_UseFlag = true;
    }

    /*
    mUseAnimFlagS = mUseAnimFlagS || mForceExportScaleKey;
    //mUseAnimFlagR = mUseAnimFlagR || mForceExportRotateKey;
    mUseAnimFlagT = mUseAnimFlagT || mForceExportTransKey;
    mUseAnimFlagD = mUseAnimFlagD || mForceExportRotateKey;
    */
}

//-----------------------------------------------------------------------------
//! @brief <light_anim> 要素を出力します。
//-----------------------------------------------------------------------------
void RLight::OutAnim( std::ostream& os, Dcc::RDataStreamArray& dataStreams, const int tabCount, const int index, const Dcc::RExpOpt& rOpt ) const
{
    static const char* const typeStrs[] = { "ambient", "directional", "point", "spot" };

    const int& tc = tabCount;

    u_int type = GetLightType();

    //-----------------------------------------------------------------------------
    // begin
    os << Dcc::RTab(tc) << "<light_anim"
        << " index=\"" << index
        << "\" light_name=\"" << Dcc::RGetUtf8FromShiftJis(mName) << "\"" << R_ENDL;
    os << Dcc::RTab(tc + 1) << "frame_count=\"" << rOpt.m_FrameCount
        << "\" loop=\"" << Dcc::RBoolStr(rOpt.m_LoopAnim) << "\"" << R_ENDL;
    os << Dcc::RTab(tc + 1) << "type=\"" << typeStrs[type] << "\"" << R_ENDL;
    os << Dcc::RTab(tc + 1) << "dist_attn_func =\"" << "" << "\"" << R_ENDL;
    os << Dcc::RTab(tc + 1) << "angle_attn_func =\"" << "" << "\"" << R_ENDL;
    os << Dcc::RTab(tc) << ">" << R_ENDL;

    //-----------------------------------------------------------------------------
    // light anim targets
    for (int iParam = 0; iParam < Dcc::RLight::PARAM_COUNT; ++iParam)
    {
        if (Dcc::RLight::POSITION_X <= iParam && iParam <= Dcc::RLight::POSITION_Z)
        {
            if (type != Dcc::RLight::POINT && type != Dcc::RLight::SPOT) continue;
        }
        else if (Dcc::RLight::DIRECTION_X <= iParam && iParam <= Dcc::RLight::DIRECTION_Z)
        {
            if (type != Dcc::RLight::DIRECTIONAL) continue;
        }
        else if (Dcc::RLight::AIM_X <= iParam && iParam <= Dcc::RLight::AIM_Z)
        {
            if (type != Dcc::RLight::SPOT) continue;
        }
        else if (iParam == Dcc::RLight::DIST_ATTN_START || iParam == Dcc::RLight::DIST_ATTN_END)
        {
            if (type != Dcc::RLight::POINT && type != Dcc::RLight::SPOT) continue;
            if (mIsDistAttnAnimEnable == false) continue;
        }
        else if (iParam == Dcc::RLight::ANGLE_ATTN_START || iParam == Dcc::RLight::ANGLE_ATTN_END)
        {
            if (type != Dcc::RLight::SPOT) continue;
        }
        else if (Dcc::RLight::COLOR1_R <= iParam && iParam <= Dcc::RLight::COLOR1_B)
        {
            continue; // color1_* を出力しません。
        }

        const Dcc::RAnimCurve& curve = mAnims[iParam];
        if ( curve.m_UseFlag )
        {
            curve.Out(os, dataStreams, tc + 1, "light_anim_target",
                Dcc::RLight::GetParamName(iParam), false);
        }
    }

    //-----------------------------------------------------------------------------
    // end
    os << Dcc::RTab(tc) << "</light_anim>" << R_ENDL;
}

/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility
