-- NintendoExport Main Script
-- Version 3.12.0
-- Copyright (C)Nintendo All rights reserved.

nintendoExportRollout = undefined
nintendoExportSavePresetRollout = undefined
nintendoExportSettingMenu = undefined

fileIn  "NintendoExportUtilities.ms.inc"

rollout nintendoExportSR_Preset "Preset Options"  
(
	dropDownList ddlSelectPreset "Preset" items:#("None") across:3 
	button btnSavePreset "Save Preset..." align:#right 
	button btnDeletePreset "Delete Preset..." align:#left 
	label Dummy01 "" across:3 offset:[0,-20]
	checkbox chkEdit "Edit Preset" offset:[0,-20] align:#right 
	checkbox chkShowUI "Show Preset UI" offset:[0,-20] align:#left 
	
	local lastPresetIdx = 0
	
	fn ddlSelectPreset_selected val forceUpdate:false =
	(
		if lastPresetIdx == val do return() --and not forceUpdate do return()
		lastPresetIdx = val
		--format "ddlSelectPreset_selected %\n" val
		
		ddlSelectPreset.selection = val
		btnSavePreset.enabled = val == 1
		chkEdit.enabled = val == 1
		btnDeletePreset.enabled = val != 1
		chkShowUI.enabled = val != 1
		chkEdit.state = false
		if val > 1 then
		(
			local fname = nintendoExportRollout.getCurrentPresetFile()
			if fname != undefined do
			(
				if forceUpdate do nintendoExportRollout.saveConfig  saveToScene:false
				--format "getCurrentPresetFile %\n" fname
				if not (nintendoExportRollout.utils.loadSettingFromFile fname isPreset:true) do
				(
					messageBox ("preset load error\n" + fname)
				)
				NintendoExport.PresetName = getFilenameFile fname -- fdest@Cfdes̃vZbgvȂP[XL邽߁AŃt@CvZbgw
				if forceUpdate do nintendoExportRollout.loadConfig loadFromScene:false
			)
		)
		else
		(
			nintendoExportRollout.redrawItems()
		)
	)
	
	on btnSavePreset pressed do 
	(
		CreateDialog nintendoExportSavePresetRollout modal:true
		nintendoExportRollout.redrawItems()
	)
	
	on btnDeletePreset pressed do 
	(
		local fname = nintendoExportRollout.getCurrentPresetFile()
		if fname == undefined do
		(
			messageBox "Preset not found"
			return()
		)
		local mes = "Do you want to delete the fdes file ?\n"
		mes += fname
		if queryBox mes title:"NintendoExport Delete Preset" do
		(
			local cmd = "del \""
			cmd += fname
			cmd += "\""
			dosCommand cmd
		)
		ddlSelectPreset_selected 1
		nintendoExportRollout.redrawItems()
	)
	
	on chkEdit changed val do 
	(
		chkShowUI.enabled = val
		nintendoExportRollout.redrawItems()
	)
	on chkShowUI changed val do nintendoExportRollout.redrawItems()
	
	on ddlSelectPreset selected val do
	(
		--format "on ddlSelectPreset selected %\n" val
		ddlSelectPreset_selected val forceUpdate:true
		--nintendoExportRollout.redrawItems()
	)
	
	on nintendoExportSR_Preset open do
	(
		--ddlSelectPreset_selected 1
		/*
		local ttstr = "vZbg̑I\n"
		for i = 1 to 50 do ttstr += "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ\n"
		ddlSelectPreset.tooltip = ttstr
		*/
	)
	on nintendoExportSR_Preset rolledUp  val  do nintendoExportRollout.resizeAll()
)


rollout nintendoExportSR_Output "Output Options" 
(
	label lblSelection "Export Target"  /*width:96 height:20*/ align:#left across: 3 
	radioButtons rdoSelection ""  /*width:80*/ height:16 labels:#("All", "Selection") columns:2 align:#left offset:[-30,0] 
	label lblDummyOut1 "" align:#left 

groupBox grp1 "" height:7 width:500 offset:[-30,0]

	label lblFilename "Output File Name"  /*width:72 height:20*/ align:#left across: 4 --offset:[0,-10]
	editText editFilename ""  width:245 align:#left  offset:[-25,0] 
	button btnNameScene "Scene"  width:45 height:16 align:#right offset:[50,0] 
	button btnNameNode "Node"  width:45 height:16 align:#right  offset:[-15,0]

	label lblFilepath "     Output Folder"  /*width:100 height:20*/ align:#left across:4 
	editText editFilepath ""  width:317 offset:[-25,0]
	label lblDummy0 ""
	button btnSelectPath "..."  width:20 height:16  align:#right offset:[-15,0]
	
	checkbox chkDisableZYConv "Disable Z-Y Axis Conversion" align:#left visible:false across:2
	label lblDummy1 "" align:#left 

groupBox grp3 "" height:7 width:500 offset:[-30,0]
	checkbox chkMergeModel "Merge fmd File"  height:16 align:#left across:4
	editText editMergeFile ""  width:310 offset:[-20,0] align:#left
	label lblDummy5 ""
	button btnSelectMerge "..."  width:20 height:16  align:#right offset:[-15,0]

	checkbox chkMergeTex "Merge ftx File"  height:16 align:#left across:4
	label lblDummyTex1 ""
	label lblDummyTex2 ""
	label lblDummyTex3 ""

	checkbox chkMergeAnim "Merge Animation Folder" height:16 align:#left across:4
	editText editMergeAnimFolder ""  width:265 offset:[25,0] align:#left
	label lblDummy6 ""
	button btnSelectMergeAnim "..." width:20 height:16 align:#right offset:[-15,0]

	label lblMergeAnimName "Merge Animation Name" height:16 offset:[18,0] align:#left across:4
	editText editMergeAnimName ""  width:172 offset:[30,0]
	label lblDummy7 ""
	label lblDummy8 ""
	
	--lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_export_target ""  height:18 width:18 pos:(getLockPos lblDummyOut1 -40) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_file_name ""  height:18 width:18 pos:(getLockPos btnNameNode 45) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_folder ""  height:18 width:18 pos:(getLockPos btnSelectPath 20) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_merge_fmd ""  height:18 width:18 pos:(getLockPos btnSelectMerge 20) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_merge_ftx ""  height:18 width:18 pos:(getLockPos chkMergeTex 90) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_merge_anim ""  height:18 width:18 pos:(getLockPos btnSelectMergeAnim 20) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_merge_anim_name ""  height:18 width:18 pos:(getLockPos editMergeAnimName 172) images:nintendoExportRollout.lockImages enabled:false
	
	
	on btnSelectPath pressed do
	(
		local filepath = getSavePath initialDir:editFilepath.text
		if(filepath != undefined) do editFilepath.text = filepath
	)
	on btnNameNode pressed do
	(
		sel = getCurrentSelection()
		if sel.count > 0 do
		(
			editFilename.text = sel[1].name
		)
	)
	on btnNameScene pressed do
	(
		if(maxFilePath == "") then
		(
			editFilename.text = "untitled"
		)
		else
		(
			editFilename.text = (getFilenameFile maxFileName)
		)
	)
	on btnSelectMerge pressed do
	(
		local filepath = getOpenFileName initialDir:editMergeFile.text types:"Model(fmda, fmdb)|*.fmda;*.fmdb|All|*.*|"
		if(filepath != undefined) do editMergeFile.text = filepath
	)
	on btnSelectMergeAnim pressed do
	(
		local filepath = getSavePath  initialDir:editMergeAnimFolder.text
		if(filepath != undefined) do editMergeAnimFolder.text = filepath
	)
	on chkMergeModel changed val do nintendoExportRollout.redrawItems()
	on chkDisableZYConv changed val do nintendoExportRollout.redrawItems()
	on chkMergeAnim changed val do nintendoExportRollout.redrawItems()

	on btnLock_export_target changed val do 
	(
		--print "btnLock_export_target changed"
		nintendoExportRollout.redrawItems()
	)
	on btnLock_output_file_name changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_folder changed val do nintendoExportRollout.redrawItems()
	on btnLock_merge_fmd changed val do nintendoExportRollout.redrawItems()
	on btnLock_merge_ftx changed val do nintendoExportRollout.redrawItems()
	on btnLock_merge_anim changed val do nintendoExportRollout.redrawItems()
	on btnLock_merge_anim_name changed val do nintendoExportRollout.redrawItems()

	on nintendoExportSR_Output rolledUp  val  do  nintendoExportRollout.resizeAll()
)

rollout nintendoExportSR_General "General Options"  
(
	spinner spnMagnify "Magnify "  width:120 height:16 range:[0.0001,10000,1] type:#float scale:0.1 align:#left across:2 
	checkbox chkUseFigureMode "Use FigureMode and SkinPose"  height:16 align:#left
	editText editComment "Comment" width:425--offset:[30,0]
	--lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_magnify ""  height:18 width:18 pos:(getLockPos spnMagnify 20) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_use_figure_mode ""  height:18 width:18 pos:(getLockPos chkUseFigureMode 170) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_comment ""  height:18 width:18 pos:(getLockPos editComment 375) images:nintendoExportRollout.lockImages enabled:false
	
	on btnLock_magnify changed val do nintendoExportRollout.redrawItems()
	on btnLock_use_figure_mode changed val do nintendoExportRollout.redrawItems()
	on btnLock_comment changed val do nintendoExportRollout.redrawItems()

	on nintendoExportSR_General rolledUp  val  do nintendoExportRollout.resizeAll()
)

rollout nintendoExportSR_Animation "Animation Options" 
(
	label lblTimeRange "Start/End Frame"  width:112 height:20 across:4 align:#left
	radioButtons rdoTimeRange ""  width:104 height:16 labels:#("All", "Range") columns:2  align:#left
	spinner spnTimeStart ""  width:64 height:16 range:[0,100000,0] type:#integer scale:1  align:#left
	spinner spnTimeEnd ""  width:64 height:16 range:[0,100000,100] type:#integer scale:1  align:#left offset:[-40,0]
	
	dropDownList ddlAnimationPrecision "Frame Precision"  width:104 height:41 items:#("1.0", "0.5", "0.2", "0.1") across:2
	checkbox chkAnimationLoop "Loop"  --width:80 height:16 
	--lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_frame_range ""  height:18 width:18 pos:(getLockPos spnTimeEnd 20) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_loop_anim ""  height:18 width:18 pos:(getLockPos chkAnimationLoop 50) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_frame_precision ""  height:18 width:18 pos:(getLockPos ddlAnimationPrecision 105) images:nintendoExportRollout.lockImages enabled:false
	
	
	on rdoTimeRange changed val do nintendoExportRollout.redrawItems()

	on btnLock_frame_range changed val do nintendoExportRollout.redrawItems()
	on btnLock_loop_anim changed val do nintendoExportRollout.redrawItems()
	on btnLock_frame_precision changed val do nintendoExportRollout.redrawItems()

	on nintendoExportSR_Animation rolledUp  val  do nintendoExportRollout.resizeAll()
)

rollout nintendoExportSR_FileSelection "Output File Selection" 
(
	label lblExportModel "Model Data " align:#right offset:[20,0] across:3
	checkbox chkExportModel "[.fmdb]" align:#left offset:[20,0]
	button btnSearchAnim "Search Model Animation" height:16 align:#left

	label lblExportTex "Texture Data " align:#right offset:[20,0] across:3
	checkbox chkExportTex "[.ftxb]" align:#left offset:[20,0]
	label DummyA02 ""

	label lblExportSkelAnim "Character Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportSkelAnim "[.fskb]" align:#left offset:[20,0]
	label DummyA03 ""

	label lblExportVisBoneAnim "Bone Visibility Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportVisBoneAnim "[.fvbb]" align:#left offset:[20,0] --enabled:false
	label DummyA04 ""


	label lblExportMtlCol "Material Color Animation Data " align:#right offset:[20,0]  across:3
	checkbox chkExportMtlCol "[.fclb]" align:#left offset:[20,0] --enabled:false
	label DummyA05 ""

	
	label lblExportTexSRT "Texture SRT Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportTexSRT "[.ftsb]" align:#left offset:[20,0] --enabled:false
	label DummyA06 ""

	label lblExportTexPat "Texture Pattern Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportTexPat "[.ftpb]" align:#left offset:[20,0]
	label DummyA07 ""

	label lblExportShape "Shape Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportShape "[.fshb]" align:#left offset:[20,0]
	label DummyA08 ""

	label lblExportScene "Scene Animation Data " align:#right offset:[20,0] across:3
	checkbox chkExportScene "[.fsnb]" align:#left offset:[20,0]
	label DummyA09 ""
	
	--lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_output_fmd ""  height:18 width:18 pos:(getLockPos chkExportModel 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_ftx ""  height:18 width:18 pos:(getLockPos chkExportTex 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_fsk ""  height:18 width:18 pos:(getLockPos chkExportSkelAnim 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_fvb ""  height:18 width:18 pos:(getLockPos chkExportVisBoneAnim 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_fcl ""  height:18 width:18 pos:(getLockPos chkExportMtlCol 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_fts ""  height:18 width:18 pos:(getLockPos chkExportTexSRT 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_ftp ""  height:18 width:18 pos:(getLockPos chkExportTexPat 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_fsh ""  height:18 width:18 pos:(getLockPos chkExportShape 76) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_output_fsn ""  height:18 width:18 pos:(getLockPos chkExportScene 76) images:nintendoExportRollout.lockImages enabled:false
	

	
	on btnSearchAnim pressed do nintendoExportRollout.searchAnimations()
	
	on chkExportModel changed val do nintendoExportRollout.redrawItems()
	on chkExportTex changed val do nintendoExportRollout.redrawItems()
	on chkExportVisBoneAnim changed val do nintendoExportRollout.redrawItems()
	on chkExportSkelAnim changed val do nintendoExportRollout.redrawItems()
	on chkExportMtlCol changed val do nintendoExportRollout.redrawItems()
	on chkExportTexPat changed val do nintendoExportRollout.redrawItems()
	on chkExportTexSRT changed val do nintendoExportRollout.redrawItems()
	on chkExportShape changed val do nintendoExportRollout.redrawItems()
	on chkExportScene changed val do nintendoExportRollout.redrawItems()
	
	on btnLock_output_fmd changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_ftx changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_fsk changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_fvb changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_fcl changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_fts changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_ftp changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_fsh changed val do nintendoExportRollout.redrawItems()
	on btnLock_output_fsn changed val do nintendoExportRollout.redrawItems()

	on nintendoExportSR_FileSelection rolledUp  val  do nintendoExportRollout.resizeAll()
)
rollout nintendoExportSR_Optimization "Optimization Options"  
(
	dropDownList ddlCompressNode "Compress Bone"  width:140 \--height:41 \
		items:#("None", "Cull", "Merge", "Unite", "Unite All") across:2
	checkbox chkUniteChild "Unite Child"   offset:[0,16]--pos:[320,8]
	checkbox chkCompressMtl "Compress Material"   across:2 --pos:[320,8] 
	checkbox chkCompressShape"Compress Shape"   --pos:[320,8] 
	-- lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_compress_bone ""  height:18 width:18 pos:(getLockPos ddlCompressNode 140) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_unite_child ""  height:18 width:18 pos:(getLockPos chkUniteChild 70) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_compress_material ""  height:18 width:18 pos:(getLockPos chkCompressMtl 110) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_compress_shape ""  height:18 width:18 pos:(getLockPos chkCompressShape 100) images:nintendoExportRollout.lockImages enabled:false

	on ddlCompressNode selected val do nintendoExportRollout.redrawItems()
	
	on btnLock_compress_bone changed val do nintendoExportRollout.redrawItems()
	on btnLock_unite_child changed val do nintendoExportRollout.redrawItems()
	on btnLock_compress_material changed val do nintendoExportRollout.redrawItems()
	on btnLock_compress_shape changed val do nintendoExportRollout.redrawItems()
	
	on nintendoExportSR_Optimization rolledUp  val  do nintendoExportRollout.resizeAll()
)

rollout nintendoExportSR_Toletance "Animation Bake Tolerance Options"  
(
	spinner spnToleranceNodeT 	"Node Translate"  width:120 height:16  range:[0,100000,0.01] type:#float scale:0.01 align:#right across:3
	spinner spnToleranceTexT 	" Texture Translate"  width:120 height:16   range:[0,100000,0.01] type:#float scale:0.01 align:#right offset:[20,0]
	spinner spnToleranceColor 	"Color"  width:80 height:16 range:[0,100000,0.001] type:#float scale:0.01 align:#right offset:[-10,0]

	spinner spnToleranceNodeR	"Node Rotate()" width:120 height:16  range:[0,100000,0.1] type:#float scale:0.01 align:#right across:3
	spinner spnToleranceTexR	" Texture Rotate()" width:120 height:16 range:[0,100000,0.1] type:#float scale:0.01  align:#right offset:[20,0]
	label lblDummyTO1 ""

	spinner spnToleranceNodeS	"         Node Scale" width:120 height:16  range:[0,100000,0.1] type:#float scale:0.01 align:#right across:3
	spinner spnToleranceTexS	"         Texture Scale" width:120 height:16 range:[0,100000,0.1] type:#float scale:0.01 align:#right offset:[20,0]
	label lblDummyTO2 ""

	-- lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_tolerance_translate ""  height:18 width:18 pos:(getLockPos spnToleranceNodeT 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_tolerance_rotate ""  height:18 width:18 pos:(getLockPos spnToleranceNodeR 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_tolerance_scale ""  height:18 width:18 pos:(getLockPos spnToleranceNodeS 10) images:nintendoExportRollout.lockImages enabled:false

	checkbutton btnLock_tolerance_tex_translate ""  height:18 width:18 pos:(getLockPos spnToleranceTexT 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_tolerance_tex_rotate ""  height:18 width:18 pos:(getLockPos spnToleranceTexR 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_tolerance_tex_scale ""  height:18 width:18 pos:(getLockPos spnToleranceTexS 10) images:nintendoExportRollout.lockImages enabled:false

	checkbutton btnLock_tolerance_color ""  height:18 width:18 pos:(getLockPos spnToleranceColor 10) images:nintendoExportRollout.lockImages enabled:false
	
	on btnLock_tolerance_translate changed val do nintendoExportRollout.redrawItems()
	on btnLock_tolerance_rotate changed val do nintendoExportRollout.redrawItems()
	on btnLock_tolerance_scale changed val do nintendoExportRollout.redrawItems()
	on btnLock_tolerance_tex_translate changed val do nintendoExportRollout.redrawItems()
	on btnLock_tolerance_tex_rotate changed val do nintendoExportRollout.redrawItems()
	on btnLock_tolerance_tex_scale changed val do nintendoExportRollout.redrawItems()
	on btnLock_tolerance_color changed val do nintendoExportRollout.redrawItems()

	on nintendoExportSR_Toletance rolledUp  val  do nintendoExportRollout.resizeAll()
)

rollout nintendoExportSR_QuantToletance "Animation Quantization Tolerance Options"  
(

	spinner spnQuantToleranceNodeT "Node Translate(%)"  width:120 height:16  range:[0,1000,0.01] type:#float scale:0.01 align:#right across:3
	spinner spnQuantToleranceTexT 	"Texture Translate(%)"  width:120 height:16   range:[0,1000,0.01] type:#float scale:0.01 align:#right offset:[40,0]
	label lblDummyTO0 ""

	spinner spnQuantToleranceNodeR	"    Node Rotate()" width:120 height:16  range:[0,1000,0.1] type:#float scale:0.01 align:#right across:3
	spinner spnQuantToleranceTexR	"    Texture Rotate()" width:120 height:16 range:[0,1000,0.1] type:#float scale:0.01  align:#right offset:[40,0]
	label lblDummyTO1 ""

	spinner spnQuantToleranceNodeS	"         Node Scale(%)" width:120 height:16  range:[0,1000,0.1] type:#float scale:0.01 align:#right across:3
	spinner spnQuantToleranceTexS	"          Texture Scale(%)" width:120 height:16 range:[0,1000,0.1] type:#float scale:0.01 align:#right offset:[40,0]
	label lblDummyTO2 ""

	-- lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_quantize_tolerance_translate ""  height:18 width:18 pos:(getLockPos spnQuantToleranceNodeT 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_quantize_tolerance_rotate ""  height:18 width:18 pos:(getLockPos spnQuantToleranceNodeR 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_quantize_tolerance_scale ""  height:18 width:18 pos:(getLockPos spnQuantToleranceNodeS 10) images:nintendoExportRollout.lockImages enabled:false

	checkbutton btnLock_quantize_tolerance_tex_translate ""  height:18 width:18 pos:(getLockPos spnQuantToleranceTexT 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_quantize_tolerance_tex_rotate ""  height:18 width:18 pos:(getLockPos spnQuantToleranceTexR 10) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_quantize_tolerance_tex_scale ""  height:18 width:18 pos:(getLockPos spnQuantToleranceTexS 10) images:nintendoExportRollout.lockImages enabled:false

	on btnLock_quantize_tolerance_translate changed val do nintendoExportRollout.redrawItems()
	on btnLock_quantize_tolerance_rotate changed val do nintendoExportRollout.redrawItems()
	on btnLock_quantize_tolerance_scale changed val do nintendoExportRollout.redrawItems()
	on btnLock_quantize_tolerance_tex_translate changed val do nintendoExportRollout.redrawItems()
	on btnLock_quantize_tolerance_tex_rotate changed val do nintendoExportRollout.redrawItems()
	on btnLock_quantize_tolerance_tex_scale changed val do nintendoExportRollout.redrawItems()

	on nintendoExportSR_QuantToletance rolledUp  val  do nintendoExportRollout.resizeAll()
)

rollout nintendoExportSR_Script "Script Options"  
(
	label lblPreExport "Pre-Export Script "align:#right 		offset:[-140,0] across:2
	editText editPreExport "" align:#left 							offset:[-140,0] width:340 
	label lblPostExport "Post-Export Script " align:#right	offset:[-140,0] across:2
	editText editPostExport "" align:#left 						offset:[-140,0] width:340 
	--lock
	fn getLockPos t w = [t.pos.x + w + 4, t.pos.y - 1]
	checkbutton btnLock_pre_export_script ""  height:18 width:18 pos:(getLockPos editPreExport 335) images:nintendoExportRollout.lockImages enabled:false
	checkbutton btnLock_post_export_script ""  height:18 width:18 pos:(getLockPos editPostExport 335) images:nintendoExportRollout.lockImages enabled:false
	
	on btnLock_pre_export_script changed val do nintendoExportRollout.redrawItems()
	on btnLock_post_export_script changed val do nintendoExportRollout.redrawItems()

	on nintendoExportSR_Script rolledUp  val  do nintendoExportRollout.resizeAll()
)


-- Main rollout
NintendoExportRollout_subOpen = #()
NintendoExportRollout_height = 1000
rollout nintendoExportRollout "NintendoExport Setting" width:500 height:1200
(
	local utils = NintendoExportUtilities()
	-- sub rollouts
	local srPreset, srOutput, srGeneral, srFileSelection, srOptimization, srQuantization, srModel, srAnimation, srToletance, srQuantToletance, srScript
	local presetsPath = undefined
	local presetFiles = #() 
	local lockIcon = undefined
	local lockIconMask = undefined
	local lockImages = undefined
	local lockInfo = #()
	
	SubRollout ro "" width:480 height:860 --align:#center --offset:[-5,0]
	button btnExport "Export" width:144 height:24 across:3
	button btnApply "Apply" width:144 height:24
	button btnClose "Close" width:144 height:24
	
	-- get registry value
	fn getRegValue root tree valueName =
	(
		if (classof tree) != Array do return undefined
		
		local oldKey = HKEY_CLASSES_ROOT 
		local key = root
		for keyName in tree while key != undefined do
		(
			oldKey = key
			registry.openKey oldKey keyName accessRights:#readOnly key:&key
		)
		
		if key == undefined do return undefined
		
		registry.queryValue key valueName type:&type value:&val
		return val
	)
	
	fn showHelp target = 
	(
		sysEnv = dotNetClass "System.Environment"

		local rootpath, htmlpath

		rootpath = sysEnv.GetEnvironmentVariable "NINTENDO_SDK_ROOT"
		if rootpath != undefined then 
		(
			 htmlpath = "file:///" + rootpath + @"\Documents\Package\contents\Pages\"
			target = case target of
			(
				@"3dsmaxPlugin.html": 								@"Page_83956010.html"
				@"html\export.html": 								@"Page_83955546.html"
				@"html\NW4F_SetMaterialAttr.html": 			@"Page_83955882.html"
				@"html\NW4F_AddMaterialAttribute.html": 	@"Page_83955882.html"
				@"html\NW4F_SetSamplerAttr.html": 			@"Page_83955852.html"
				@"html\NW4F_SetNoCompressNode.html": 	@"Page_83955850.html"
				@"html\NW4F_SetShapeAnimation.html": 		@"Page_83955847.html"
				@"html\NW4F_SetUserData.html": 				@"Page_83955844.html"
				@"html\NW4F_MultiExport.html": 				@"Page_83955898.html"
				
				default: target
			)
		)
		else
		(
			rootpath = sysEnv.GetEnvironmentVariable "NW4F_ROOT"
			if rootpath == undefined do 
			(
				messageBox "System Environment(NW4F_ROOT or NINTENDO_SDK_ROOT) isn't valid."
				return false
			)
			 htmlpath = "file:///" + rootpath + @"\Document\Graphics\DccPlugin\3dsMax\"
		)
		
		htmlpath += target 
		
		local rootAssocProg = getRegValue HKEY_CLASSES_ROOT  #(".html") ""
		if rootAssocProg == undefined do 
		(
			messageBox "Can't find Browser."
			return false
		)

		local customAssocProg = getRegValue HKEY_CURRENT_USER #("Software","Microsoft","Windows","CurrentVersion","Explorer","FileExts",".html","UserChoice") "Progid"
		
		local assocProg = if customAssocProg != undefined then customAssocProg else rootAssocProg
			
		local exeVal = getRegValue HKEY_CLASSES_ROOT #(assocProg, "shell","open","command") ""
		
		if exeVal == undefined do 
		(
			messageBox "Can't find Browser executable."
			return false
		)
		
		exeVal = substituteString exeVal "\"%1\"" ""
		exe = (filterString exeVal "\"")[1]
		--print exe
		-- ie or not
		if (findString exe "explorer") != undefined then
		(
			local ie = createOLEObject "InternetExplorer.Application"
			--print ie
			ie.visible = true
			ie.navigate htmlpath
			releaseOLEObject ie 
		)
		else
		(
			ShellLaunch exe  ("\"" + htmlpath + "\"")
		)
	)
	
	fn getCurrentPresetFile = 
	(
		local idx = srPreset.ddlSelectPreset.selection - 1 --"None" 
		if presetFiles.count == 0 or idx <= 0 or idx > presetFiles.count do
		(
			return undefined
		)
		
		local fname = presetFiles[idx]
		if not (doesFileExist fname) do
		(
			return undefined
		)
		
		return fname
	)
	
	
	fn listUpPreset =
	(
		presetFiles = #()
		presetsPath = utils.getPresetsFolder()
		if presetsPath == undefined then
		(
			messagebox "Preset path not found"
			return()
		)
		else
		(
			-- asciĩt@C̓vZbgɂȂ
			local fdesFiles = getFiles (pathConfig.appendPath presetsPath @"*.fdes")
			for fpath in fdesFiles do
			(
				local fname = (getFilenameFile fpath)
				if (utils.isValidPresetName fname) do
				(
					append presetFiles fpath
				)
			)
		)
		
		local ddl = srPreset.ddlSelectPreset
		local ddlsel = ddl.selection
		--print ddlsel
		--ddl.enabled  = false
		
		local presets = #("None")
		for f in presetFiles do
		(
			presets = append presets (getFilenameFile f)
		)
		ddl.items = presets
		if(ddlsel > 0  and ddlsel <= ddl.items.count) do ddl.selection = ddlsel
		--ddl.enabled  = true
	)
	
	fn setPresetDDL pname =
	(
		--format "setPresetDDL %\n" pname
		if pname == "" then
		(
			--srPreset.ddlSelectPreset.selection = 1 -- "None"
			srPreset.ddlSelectPreset_selected  1
		)
		else
		(
			local idx = 0
			for i = 1 to presetFiles.count while (idx == 0) do
			(
				if (stricmp pname (getFileNameFile presetFiles[i]) ) == 0 do
				(
					idx = i
				)
			)
			idx += 1
			srPreset.ddlSelectPreset_selected  idx
			--srPreset.ddlSelectPreset.selection = idx
		)
	)
	
	fn setLockInfo =
	(
		lockInfo = #( \
			 #(srOutput.btnLock_export_target, #(srOutput.lblSelection, srOutput.rdoSelection), true, #()) \
			,#(srOutput.btnLock_output_file_name, #(srOutput.lblFilename, srOutput.editFilename, srOutput.btnNameScene, srOutput.btnNameNode), true, #()) \
			,#(srOutput.btnLock_output_folder, #(srOutput.lblFilepath, srOutput.editFilepath, srOutput.btnSelectPath), true, #()) \
			,#(srOutput.btnLock_merge_fmd, #(srOutput.chkMergeModel, srOutput.editMergeFile, srOutput.btnSelectMerge), false, #()) \
			,#(srOutput.btnLock_merge_ftx, #(srOutput.chkMergeTex), false, #()) \
			,#(srOutput.btnLock_merge_anim, #(srOutput.chkMergeAnim, srOutput.editMergeAnimFolder, srOutput.btnSelectMergeAnim), false, #()) \
			,#(srOutput.btnLock_merge_anim_name, #(srOutput.lblMergeAnimName, srOutput.editMergeAnimName), false, #()) \
			,#(srGeneral.btnLock_magnify , #(srGeneral.spnMagnify), true, #()) \
			,#(srGeneral.btnLock_use_figure_mode , #(srGeneral.chkUseFigureMode), true, #()) \
			,#(srGeneral.btnLock_comment , #(srGeneral.editComment), true, #()) \
			,#(srAnimation.btnLock_frame_range, #(srAnimation.lblTimeRange, srAnimation.rdoTimeRange, srAnimation.spnTimeStart, srAnimation.spnTimeEnd), false, #()) \
			,#(srAnimation.btnLock_frame_precision, #(srAnimation.ddlAnimationPrecision), true, #()) \
			,#(srAnimation.btnLock_loop_anim, #(srAnimation.chkAnimationLoop), true, #()) \
			,#(srFileSelection.btnLock_output_fmd, #(srFileSelection.lblExportModel, srFileSelection.chkExportModel), true, #()) \
			,#(srFileSelection.btnLock_output_ftx, #(srFileSelection.lblExportTex, srFileSelection.chkExportTex), true, #()) \
			,#(srFileSelection.btnLock_output_fsk, #(srFileSelection.lblExportSkelAnim, srFileSelection.chkExportSkelAnim), true, #()) \
			,#(srFileSelection.btnLock_output_fvb, #(srFileSelection.lblExportVisBoneAnim, srFileSelection.chkExportVisBoneAnim), true, #()) \
			,#(srFileSelection.btnLock_output_fcl, #(srFileSelection.lblExportMtlCol, srFileSelection.chkExportMtlCol), true, #()) \
			,#(srFileSelection.btnLock_output_fts, #(srFileSelection.lblExportTexSRT, srFileSelection.chkExportTexSRT), true, #()) \
			,#(srFileSelection.btnLock_output_ftp, #(srFileSelection.lblExportTexPat, srFileSelection.chkExportTexPat), true, #()) \
			,#(srFileSelection.btnLock_output_fsh, #(srFileSelection.lblExportShape, srFileSelection.chkExportShape), true, #()) \
			,#(srFileSelection.btnLock_output_fsn, #(srFileSelection.lblExportScene, srFileSelection.chkExportScene), true, #()) \
			,#(srOptimization.btnLock_compress_bone , #(srOptimization.ddlCompressNode), false, #()) \
			,#(srOptimization.btnLock_unite_child , #(srOptimization.chkUniteChild), false, #()) \
			,#(srOptimization.btnLock_compress_material , #(srOptimization.chkCompressMtl), false, #()) \
			,#(srOptimization.btnLock_compress_shape , #(srOptimization.chkCompressShape), false, #()) \
			,#(srToletance.btnLock_tolerance_translate , #(srToletance.spnToleranceNodeT), false, #()) \
			,#(srToletance.btnLock_tolerance_rotate , #(srToletance.spnToleranceNodeR), false, #()) \
			,#(srToletance.btnLock_tolerance_scale , #(srToletance.spnToleranceNodeS), false, #()) \
			,#(srToletance.btnLock_tolerance_tex_translate , #(srToletance.spnToleranceTexT), false, #()) \
			,#(srToletance.btnLock_tolerance_tex_rotate , #(srToletance.spnToleranceTexR), false, #()) \
			,#(srToletance.btnLock_tolerance_tex_scale , #(srToletance.spnToleranceTexS), false, #()) \
			,#(srToletance.btnLock_tolerance_color , #(srToletance.spnToleranceColor), false, #()) \
			,#(srQuantToletance.btnLock_quantize_tolerance_translate , #(srQuantToletance.spnQuantToleranceNodeT), false, #()) \
			,#(srQuantToletance.btnLock_quantize_tolerance_rotate , #(srQuantToletance.spnQuantToleranceNodeR), false, #()) \
			,#(srQuantToletance.btnLock_quantize_tolerance_scale , #(srQuantToletance.spnQuantToleranceNodeS), false, #()) \
			,#(srQuantToletance.btnLock_quantize_tolerance_tex_translate , #(srQuantToletance.spnQuantToleranceTexT), false, #()) \
			,#(srQuantToletance.btnLock_quantize_tolerance_tex_rotate , #(srQuantToletance.spnQuantToleranceTexR), false, #()) \
			,#(srQuantToletance.btnLock_quantize_tolerance_tex_scale , #(srQuantToletance.spnQuantToleranceTexS), false, #()) \
			,#(srScript.btnLock_pre_export_script , #(srScript.lblPreExport, srScript.editPreExport), true, #()) \
			,#(srScript.btnLock_post_export_script , #(srScript.lblPostExport, srScript.editPostExport), true, #()) \
		)
	)
	
	fn lockAll val =
	(
		if srPreset.chkEdit.state and (classof val) == booleanClass do
		(
			for info in lockInfo do
			(
				if (classof info) == array do
				(
					local btn = info[1]
					btn.state = val
				)
			)
		)
		nintendoExportRollout.redrawItems()
	)
	
	fn showPresetUI =
	(
		--local showUI = srPreset.chkEdit.state
		local showUI = srPreset.chkShowUI.state or srPreset.chkEdit.enabled
		--format "showPresetUI %\n" showUI
		for info in lockInfo do
		(
			--print "\n"
			--print info
			if ((classof info) == array) and (info.count >= 2)do
			(
				local btn = info[1]
				local items = info[2]
				--print btn
				if (classof items) == array do
				(
					local val = not btn.state or showUI
					btn.visible = val
					for i in items do
					(
						i.visible = val
					)
				)
			)
		)
	)

	fn redrawItems = 
	(
		-- presets
		listUpPreset()
		showPresetUI()
		
		srAnimation.spnTimeStart.enabled = srAnimation.spnTimeEnd.enabled = (srAnimation.rdoTimeRange.state == 2)

		srOutput.chkDisableZYConv.visible = utils.showDisableZYAxisConversion
		srOutput.chkMergeTex.enabled  = srFileSelection.chkExportTex.state \
			or (srFileSelection.chkExportModel.state and (not srOutput.chkMergeModel.state) )
		
		-- lock
		local bEditLock = srPreset.chkEdit.state
		
		-- hide unlock icon
		for info in lockInfo do
		(
			if (classof info) == array do
			(
				local btn = info[1]
				btn.enabled = bEditLock
				if btn.visible do btn.visible = bEditLock or btn.state
			)
		)
		
		local bAnim = false , bFrame = false, bOptNode = false, bOptMtlShape = false, bQuantize = false, bToleRT = false, bToleS = false, bToleTex = false, bToleCol = false
		
		if srFileSelection.chkExportModel.state do
		(
			bOptNode = bOptMtlShape = true
		)
		
		if srFileSelection.chkExportVisBoneAnim.state do
		(
			bAnim = bOptNode = true
		)
		if srFileSelection.chkExportSkelAnim.state do
		(
			bAnim = bOptNode  = bFrame = bQuantize = bToleRT = bToleS = true
		)
		
		/*
		if srFileSelection.chkExportCamera.state do
		(
			bAnim = bToleRT = true
		)
		*/
		/*
		if srFileSelection.chkExportLight.state do
		(
			bAnim = bToleRT = bToleCol = true
		)
		*/
		if srFileSelection.chkExportMtlCol.state do
		(
			bAnim = bToleCol = true
		)
		if srFileSelection.chkExportTexPat.state do
		(
			bAnim = true
		)
		if srFileSelection.chkExportShape.state do
		(
			bAnim = true
		)
		if srFileSelection.chkExportScene.state do
		(
			bAnim = bToleRT = bToleCol = true
		)
		if srFileSelection.chkExportTexSRT.state do
		(
			bAnim = bToleTex = true
		)

		srAnimation.ddlAnimationPrecision.enabled = bAnim
		srAnimation.chkAnimationLoop.enabled = bAnim
		
		srOptimization.chkUniteChild.enabled = bOptNode and (srOptimization.ddlCompressNode.selection != 4)
		srOptimization.ddlCompressNode.enabled = bOptNode 
		
		srOptimization.chkCompressMtl.enabled = bOptMtlShape
		srOptimization.chkCompressShape.enabled = bOptMtlShape
		
		srToletance.spnToleranceNodeT.enabled = bToleRT
		srToletance.spnToleranceNodeR.enabled = bToleRT

		srToletance.spnToleranceNodeS.enabled = bToleS

		srToletance.spnToleranceTexT.enabled = bToleTex
		srToletance.spnToleranceTexR.enabled = bToleTex
		srToletance.spnToleranceTexS.enabled = bToleTex
				
		srToletance.spnToleranceColor.enabled = bToleCol
		--
		srQuantToletance.spnQuantToleranceNodeT.enabled = bToleRT
		srQuantToletance.spnQuantToleranceNodeR.enabled = bToleRT

		srQuantToletance.spnQuantToleranceNodeS.enabled = bToleS

		srQuantToletance.spnQuantToleranceTexT.enabled = bToleTex
		srQuantToletance.spnQuantToleranceTexR.enabled = bToleTex
		srQuantToletance.spnQuantToleranceTexS.enabled = bToleTex
				
		srOutput.chkMergeAnim.enabled = bAnim
		srOutput.editMergeAnimFolder.enabled = srOutput.btnSelectMergeAnim.enabled \
			= srOutput.editMergeAnimName.enabled = srOutput.lblMergeAnimName.enabled \
			= bAnim and srOutput.chkMergeAnim.state
		
		-- lock enable
		for info in lockInfo do
		(
			if ((classof info) == array) and (info.count >= 3)do
			(
				local btn = info[1]
				local items = info[2]
				local flag = info[3]
				--print btn
				if ((classof items) == array) and (flag == true) do
				(
					local val = not btn.state
					for i in items do
					(
						i.enabled = val
					)
				)
			)
		)
		
		
		srOutput.chkMergeModel.enabled = not srOutput.btnLock_merge_fmd.state and srFileSelection.chkExportModel.state
		srOutput.editMergeFile.enabled = srOutput.btnSelectMerge.enabled = \
			srOutput.chkMergeModel.state and srOutput.chkMergeModel.enabled
		
		srOutput.chkMergeTex.enabled = \
			if srOutput.btnLock_merge_ftx.state then false else srOutput.chkMergeTex.enabled
				
		srOutput.chkMergeAnim.enabled = not srOutput.btnLock_merge_anim.state and bAnim
		srOutput.editMergeAnimFolder.enabled = srOutput.btnSelectMergeAnim.enabled = \
			srOutput.chkMergeAnim.state and srOutput.chkMergeAnim.enabled 
				
		srOutput.lblMergeAnimName.enabled = srOutput.editMergeAnimName.enabled = \
			if srOutput.btnLock_merge_anim_name.state then  false else srOutput.lblMergeAnimName.enabled
			
			
		srAnimation.lblTimeRange.enabled = srAnimation.rdoTimeRange.enabled = not srAnimation.btnLock_frame_range.state
		if srAnimation.btnLock_frame_range.state do srAnimation.spnTimeStart.enabled = srAnimation.spnTimeEnd.enabled = false
		
		if srOptimization.btnLock_compress_bone.state do srOptimization.ddlCompressNode.enabled = false
		if srOptimization.btnLock_unite_child.state do srOptimization.chkUniteChild.enabled = false
		if srOptimization.btnLock_compress_material.state do srOptimization.chkCompressMtl.enabled = false
		if srOptimization.btnLock_compress_shape.state do srOptimization.chkCompressShape.enabled = false
			
		if srToletance.btnLock_tolerance_translate.state do srToletance.spnToleranceNodeT.enabled = false
		if srToletance.btnLock_tolerance_rotate.state do srToletance.spnToleranceNodeR.enabled = false
		if srToletance.btnLock_tolerance_scale.state do srToletance.spnToleranceNodeS.enabled = false
		if srToletance.btnLock_tolerance_tex_translate.state do srToletance.spnToleranceTexT.enabled = false
		if srToletance.btnLock_tolerance_tex_rotate.state do srToletance.spnToleranceTexR.enabled = false
		if srToletance.btnLock_tolerance_tex_scale.state do srToletance.spnToleranceTexS.enabled = false
		if srToletance.btnLock_tolerance_color.state do srToletance.spnToleranceColor.enabled = false
			
		if srQuantToletance.btnLock_quantize_tolerance_translate.state do srQuantToletance.spnQuantToleranceNodeT.enabled = false
		if srQuantToletance.btnLock_quantize_tolerance_rotate.state do srQuantToletance.spnQuantToleranceNodeR.enabled = false
		if srQuantToletance.btnLock_quantize_tolerance_scale.state do srQuantToletance.spnQuantToleranceNodeS.enabled = false
		if srQuantToletance.btnLock_quantize_tolerance_tex_translate.state do srQuantToletance.spnQuantToleranceTexT.enabled = false
		if srQuantToletance.btnLock_quantize_tolerance_tex_rotate.state do srQuantToletance.spnQuantToleranceTexR.enabled = false
		if srQuantToletance.btnLock_quantize_tolerance_tex_scale.state do srQuantToletance.spnQuantToleranceTexS.enabled = false
			
		local exts = utils.GetMatAnimExtensions()
		srFileSelection.chkExportMtlCol.text   = "[" + exts[1] + "]"
		srFileSelection.chkExportTexSRT.text = "[" + exts[2] + "]"
		srFileSelection.chkExportTexPat.text  = "[" + exts[3] + "]"
		
		/*
		local ninexp = NintendoExport
		if ninexp.GetUseFclFtsFtp() then
		(
			srFileSelection.chkExportMtlCol.text   = "[.fclb]"
			srFileSelection.chkExportTexSRT.text = "[.ftsb]"
			srFileSelection.chkExportTexPat.text  = "[.ftpb]"
		)
		else 
		(
			if ninexp.GetSeparateMaterialAnim() then
			(
				srFileSelection.chkExportMtlCol.text   = "[_fcl.fmab]"
				srFileSelection.chkExportTexSRT.text = "[_fts.fmab]"
				srFileSelection.chkExportTexPat.text  = "[_ftp.fmab]"
			)
			else
			(
				srFileSelection.chkExportMtlCol.text   = "[.fmab]"
				srFileSelection.chkExportTexSRT.text = "[.fmab]"
				srFileSelection.chkExportTexPat.text  = "[.fmab]"
			)
		)
		*/
	)

	fn searchAnimations = 
	(
		local ninexp = NintendoExport
		local animStr = ninexp.searchAnimations (srOutput.rdoSelection.state == 2)
		--print animStr
		local anims = filterString animStr ", "
		--print anims
		--if anims.count > 0 do
		(
			if not srFileSelection.btnLock_output_fsk.state do srFileSelection.chkExportSkelAnim.state = false
			if not srFileSelection.btnLock_output_fvb.state do srFileSelection.chkExportVisBoneAnim.state = false
			if not srFileSelection.btnLock_output_fcl.state do srFileSelection.chkExportMtlCol.state = false
			if not srFileSelection.btnLock_output_ftp.state do srFileSelection.chkExportTexPat.state = false
			if not srFileSelection.btnLock_output_fts.state do srFileSelection.chkExportTexSRT.state = false
			if not srFileSelection.btnLock_output_fsh.state do srFileSelection.chkExportShape.state = false
			--if not srFileSelection.btnLock_output_fsn.state do srFileSelection.chkExportScene.state = false
			for str in anims do
			(
				case str of
				(
					"FSK": if not srFileSelection.btnLock_output_fsk.state do srFileSelection.chkExportSkelAnim.state = true
					"FVB": if not srFileSelection.btnLock_output_fvb.state do srFileSelection.chkExportVisBoneAnim.state = true
					"FCL": if not srFileSelection.btnLock_output_fcl.state do srFileSelection.chkExportMtlCol.state = true
					"FTS": if not srFileSelection.btnLock_output_fts.state do srFileSelection.chkExportTexSRT.state = true
					"FTP": if not srFileSelection.btnLock_output_ftp.state do srFileSelection.chkExportTexPat.state = true
					"FSH": if not srFileSelection.btnLock_output_fsh.state do srFileSelection.chkExportShape.state = true
					--"FSN": if not srFileSelection.btnLock_output_fsn.state do srFileSelection.chkExportScene.state = true
				)
			)
		)
		redrawItems()
	)
	
	fn loadConfig loadFromScene:true = 
	(
		--print "load config"
		local ninexp = NintendoExport
		if loadFromScene do 
		(
			ninexp.LoadSetting()
			--utils.saveSettingDefault()
		)
		
		-- preset
		listUpPreset()
		setPresetDDL ninexp.PresetName
		
		srPreset.chkShowUI.state = ninexp.ShowPresetUI

		srOutput.rdoSelection.state = (if ninexp.doesExportSelected then 2 else 1)
		srOutput.editFilename.text = ninexp.filename
		srOutput.editFilepath.text = ninexp.outputFolder
		srOutput.chkDisableZYConv.state = ninexp.DisableZYAxisConversion
		
		srOutput.chkMergeModel.state = ninexp.UseMerge
		srOutput.editMergeFile.text = ninexp.MergeFilename
		srOutput.chkMergeTex.state = ninexp.UseMergeFtx
		srOutput.chkMergeAnim.state = ninexp.UseMergeAnim
		srOutput.editMergeAnimFolder.text = ninexp.MergeAnimFolder
		srOutput.editMergeAnimName.text = ninexp.MergeAnimName
		---------------------------------------------------
		srGeneral.spnMagnify.value = ninexp.magnify
		srGeneral.chkUseFigureMode.state = ninexp.useFiguremode
		srGeneral.editComment.text = ninexp.commentText
		--srGeneral.chkIsBinary.state = ninexp.isBinaryFormat
		---------------------------------------------------
		srFileSelection.chkExportModel.state = ninexp.doesExportModel
		srFileSelection.chkExportTex.state = ninexp.doesExportTexture
		srFileSelection.chkExportSkelAnim.state = ninexp.doesExportSkelAnim
		--srFileSelection.chkExportCamera.state = ninexp.doesExportCamera
		--srFileSelection.chkExportLight.state = ninexp.doesExportLight
		srFileSelection.chkExportVisBoneAnim.state = ninexp.doesExportVisBoneAnim
		--srFileSelection.chkExportEnv.state = ninexp.doesExportEnv
		srFileSelection.chkExportMtlCol.state = ninexp.doesExportMtlColorAnim
		srFileSelection.chkExportTexPat.state = ninexp.doesExportMtlTexPatternAnim
		srFileSelection.chkExportTexSRT.state = ninexp.doesExportMtlTexSRTAnim
		srFileSelection.chkExportScene.state = ninexp.doesExportSceneAnim
		srFileSelection.chkExportShape.state = ninexp.doesExportShapeAnim
		
		---------------------------------------------------
		srOptimization.ddlCompressNode.selection = ninexp.CompressNode
		srOptimization.chkUniteChild.state = ninexp.doesUniteChild
		srOptimization.chkCompressMtl.state = ninexp.doesCompressMaterial
		srOptimization.chkCompressShape.state = ninexp.doesCompressShape
		---------------------------------------------------
		srAnimation.rdoTimeRange.state = (if ninexp.doesExportAllFrames then 1 else 2)
		srAnimation.spnTimeStart.value = ninexp.startFrame
		srAnimation.spnTimeEnd.value = ninexp.endFrame
		srAnimation.chkAnimationLoop.state = ninexp.isLoop
		srAnimation.ddlAnimationPrecision.selection = case of
		(
				(1 >= ninexp.framePrecision) : 1
				(2 >= ninexp.framePrecision) : 2
				(5 >= ninexp.framePrecision) : 3
				(10 >= ninexp.framePrecision) : 4
				default: 1
		)
		---------------------------------------------------
		srToletance.spnToleranceNodeT.value = ninexp.ToleranceTrans
		srToletance.spnToleranceNodeR.value = ninexp.ToleranceRotate
		srToletance.spnToleranceNodeS.value = ninexp.ToleranceScale
		--
		srToletance.spnToleranceTexT.value = ninexp.ToleranceUVTrans
		srToletance.spnToleranceTexR.value = ninexp.ToleranceUVRotate
		srToletance.spnToleranceTexS.value = ninexp.ToleranceUVScale
		srToletance.spnToleranceColor.value = ninexp.ToleranceColor
		---------------------------------------------------
		srQuantToletance.spnQuantToleranceNodeT.value = ninexp.QuantToleranceTrans * 100.0
		srQuantToletance.spnQuantToleranceNodeR.value = ninexp.QuantToleranceRotate
		srQuantToletance.spnQuantToleranceNodeS.value = ninexp.QuantToleranceScale * 100.0
		--
		srQuantToletance.spnQuantToleranceTexT.value = ninexp.QuantToleranceUVTrans * 100.0
		srQuantToletance.spnQuantToleranceTexR.value = ninexp.QuantToleranceUVRotate
		srQuantToletance.spnQuantToleranceTexS.value = ninexp.QuantToleranceUVScale * 100.0
		---------------------------------------------------
		srScript.editPreExport.text = ninexp.PreExportScript
		srScript.editPostExport.text = ninexp.PostExportScript
		---------------------------------------------------
		-- lock 
		srOutput.btnLock_export_target.state = ninexp.Lock_export_target
		srOutput.btnLock_output_file_name.state = ninexp.Lock_output_file_name
		srOutput.btnLock_output_folder.state = ninexp.Lock_output_folder
		srOutput.btnLock_merge_fmd.state = ninexp.Lock_merge_fmd
		srOutput.btnLock_merge_ftx.state = ninexp.Lock_merge_ftx
		srOutput.btnLock_merge_anim.state = ninexp.Lock_merge_anim
		srOutput.btnLock_merge_anim_name.state = ninexp.Lock_merge_anim_name


		srGeneral.btnLock_magnify.state = ninexp.Lock_magnify
		srGeneral.btnLock_use_figure_mode.state = ninexp.Lock_use_figure_mode
		srGeneral.btnLock_comment.state = ninexp.Lock_comment


		srAnimation.btnLock_frame_range.state = ninexp.Lock_frame_range
		srAnimation.btnLock_loop_anim.state = ninexp.Lock_loop_anim
		srAnimation.btnLock_frame_precision.state = ninexp.Lock_frame_precision


		srFileSelection.btnLock_output_fmd.state = ninexp.Lock_output_fmd
		srFileSelection.btnLock_output_ftx.state = ninexp.Lock_output_ftx
		srFileSelection.btnLock_output_fsk.state = ninexp.Lock_output_fsk
		srFileSelection.btnLock_output_fvb.state = ninexp.Lock_output_fvb
		srFileSelection.btnLock_output_fcl.state = ninexp.Lock_output_fcl
		srFileSelection.btnLock_output_fts.state = ninexp.Lock_output_fts
		srFileSelection.btnLock_output_ftp.state = ninexp.Lock_output_ftp
		srFileSelection.btnLock_output_fsh.state = ninexp.Lock_output_fsh
		srFileSelection.btnLock_output_fsn.state = ninexp.Lock_output_fsn


		srOptimization.btnLock_compress_bone.state = ninexp.Lock_compress_bone
		srOptimization.btnLock_unite_child.state = ninexp.Lock_unite_child
		srOptimization.btnLock_compress_material.state = ninexp.Lock_compress_material
		srOptimization.btnLock_compress_shape.state = ninexp.Lock_compress_shape


		srToletance.btnLock_tolerance_translate.state = ninexp.Lock_tolerance_translate
		srToletance.btnLock_tolerance_rotate.state = ninexp.Lock_tolerance_rotate
		srToletance.btnLock_tolerance_scale.state = ninexp.Lock_tolerance_scale

		srToletance.btnLock_tolerance_tex_translate.state = ninexp.Lock_tolerance_tex_translate
		srToletance.btnLock_tolerance_tex_rotate.state = ninexp.Lock_tolerance_tex_rotate
		srToletance.btnLock_tolerance_tex_scale.state = ninexp.Lock_tolerance_tex_scale

		srToletance.btnLock_tolerance_color.state = ninexp.Lock_tolerance_color


		srQuantToletance.btnLock_quantize_tolerance_translate.state = ninexp.Lock_quantize_tolerance_translate
		srQuantToletance.btnLock_quantize_tolerance_rotate.state = ninexp.Lock_quantize_tolerance_rotate
		srQuantToletance.btnLock_quantize_tolerance_scale.state = ninexp.Lock_quantize_tolerance_scale

		srQuantToletance.btnLock_quantize_tolerance_tex_translate.state = ninexp.Lock_quantize_tolerance_tex_translate
		srQuantToletance.btnLock_quantize_tolerance_tex_rotate.state = ninexp.Lock_quantize_tolerance_tex_rotate
		srQuantToletance.btnLock_quantize_tolerance_tex_scale.state = ninexp.Lock_quantize_tolerance_tex_scale
		
		srScript.btnLock_pre_export_script.state = ninexp.Lock_pre_export_script
		srScript.btnLock_post_export_script.state = ninexp.Lock_post_export_script
		
		-- t@CApX󔒂̏ꍇɓKȒl
		if(srOutput.editFilepath.text == "") do
		(
			-- maxt@Cǂݍ݁EۑĂȂꍇ
			if(maxFilePath == "") then srOutput.editFilepath.text = (pathConfig.getDir #export)
			else srOutput.editFilepath.text = maxFilePath
		)
		if(srOutput.editFilename.text == "") do
		(
			-- maxt@Cǂݍ݁EۑĂȂꍇ
			if(maxFilePath == "") then srOutput.editFilename.text = "untitled"
			else srOutput.editFilename.text = (getFilenameFile maxFileName)
		)
		redrawItems()
	)
	
	fn saveConfig  saveToScene:true = 
	(
		--print "save config"
		local ninexp = NintendoExport
		---------------------------------------------------
		local pfName = getCurrentPresetFile()
		ninexp.PresetFile = if pfName == undefined then "" else pfName
		ninexp.PresetName = if pfName == undefined then "" else (getFilenameFile pfName)
		ninexp.ShowPresetUI = srPreset.chkShowUI.state
		---------------------------------------------------
		ninexp.doesExportSelected = (srOutput.rdoSelection.state == 2)
		ninexp.outputFolder = srOutput.editFilepath.text
		ninexp.filename = srOutput.editFilename.text
		ninexp.DisableZYAxisConversion = srOutput.chkDisableZYConv.state
		ninexp.UseMerge = srOutput.chkMergeModel.state
		ninexp.MergeFilename = srOutput.editMergeFile.text
		ninexp.UseMergeFtx = srOutput.chkMergeTex.state
		ninexp.UseMergeAnim = srOutput.chkMergeAnim.state
		ninexp.MergeAnimFolder = srOutput.editMergeAnimFolder.text
		ninexp.MergeAnimName = srOutput.editMergeAnimName.text
		---------------------------------------------------
		ninexp.magnify = srGeneral.spnMagnify.value
		ninexp.useFiguremode = srGeneral.chkUseFigureMode.state
		ninexp.commentText = srGeneral.editComment.text
		---------------------------------------------------
		ninexp.doesExportModel = srFileSelection.chkExportModel.state 
		ninexp.doesExportTexture = srFileSelection.chkExportTex.state
		ninexp.doesExportSkelAnim = srFileSelection.chkExportSkelAnim.state
		--ninexp.doesExportCamera = srFileSelection.chkExportCamera.state 
		--ninexp.doesExportLight = srFileSelection.chkExportLight.state 
		ninexp.doesExportVisBoneAnim = srFileSelection.chkExportVisBoneAnim.state
		--ninexp.doesExportEnv = srFileSelection.chkExportEnv.state
		ninexp.doesExportMtlColorAnim = srFileSelection.chkExportMtlCol.state 
		ninexp.doesExportMtlTexPatternAnim = srFileSelection.chkExportTexPat.state 
		ninexp.doesExportMtlTexSRTAnim = srFileSelection.chkExportTexSRT.state 
		ninexp.doesExportSceneAnim = srFileSelection.chkExportScene.state 
		ninexp.doesExportShapeAnim = srFileSelection.chkExportShape.state 
		---------------------------------------------------
		ninexp.doesExportAllFrames = (srAnimation.rdoTimeRange.state == 1)
		ninexp.startFrame = srAnimation.spnTimeStart.value
		ninexp.endFrame = srAnimation.spnTimeEnd.value
		ninexp.isLoop = srAnimation.chkAnimationLoop.state
		ninexp.framePrecision = case srAnimation.ddlAnimationPrecision.selection of
			(
				1: 1
				2: 2
				3: 5
				4: 10
				default: 1
			)
		---------------------------------------------------
		ninexp.CompressNode = srOptimization.ddlCompressNode.selection
		ninexp.doesUniteChild = srOptimization.chkUniteChild.state
		ninexp.doesCompressMaterial = srOptimization.chkCompressMtl.state
		ninexp.doesCompressShape = srOptimization.chkCompressShape.state
		---------------------------------------------------
		ninexp.ToleranceTrans = srToletance.spnToleranceNodeT.value
		ninexp.ToleranceRotate = srToletance.spnToleranceNodeR.value
		ninexp.ToleranceScale = srToletance.spnToleranceNodeS.value
		--
		ninexp.ToleranceUVTrans = srToletance.spnToleranceTexT.value 
		ninexp.ToleranceUVRotate = srToletance.spnToleranceTexR.value 
		ninexp.ToleranceUVScale = srToletance.spnToleranceTexS.value 
		ninexp.ToleranceColor = srToletance.spnToleranceColor.value 
		---------------------------------------------------
		ninexp.QuantToleranceTrans = srQuantToletance.spnQuantToleranceNodeT.value * 0.01
		ninexp.QuantToleranceRotate = srQuantToletance.spnQuantToleranceNodeR.value
		ninexp.QuantToleranceScale = srQuantToletance.spnQuantToleranceNodeS.value * 0.01
		--
		ninexp.QuantToleranceUVTrans = srQuantToletance.spnQuantToleranceTexT.value  * 0.01
		ninexp.QuantToleranceUVRotate = srQuantToletance.spnQuantToleranceTexR.value 
		ninexp.QuantToleranceUVScale = srQuantToletance.spnQuantToleranceTexS.value * 0.01
		---------------------------------------------------
		ninexp.PreExportScript = srScript.editPreExport.text
		ninexp.PostExportScript = srScript.editPostExport.text
		---------------------------------------------------
		-- lock
		ninexp.Lock_export_target = srOutput.btnLock_export_target.state
		ninexp.Lock_output_file_name = srOutput.btnLock_output_file_name.state
		ninexp.Lock_output_folder = srOutput.btnLock_output_folder.state
		ninexp.Lock_merge_fmd = srOutput.btnLock_merge_fmd.state
		ninexp.Lock_merge_ftx = srOutput.btnLock_merge_ftx.state
		ninexp.Lock_merge_anim = srOutput.btnLock_merge_anim.state
		ninexp.Lock_merge_anim_name = srOutput.btnLock_merge_anim_name.state


		ninexp.Lock_magnify = srGeneral.btnLock_magnify.state
		ninexp.Lock_use_figure_mode = srGeneral.btnLock_use_figure_mode.state
		ninexp.Lock_comment = srGeneral.btnLock_comment.state


		ninexp.Lock_frame_range = srAnimation.btnLock_frame_range.state
		ninexp.Lock_loop_anim = srAnimation.btnLock_loop_anim.state
		ninexp.Lock_frame_precision = srAnimation.btnLock_frame_precision.state


		ninexp.Lock_output_fmd = srFileSelection.btnLock_output_fmd.state
		ninexp.Lock_output_ftx = srFileSelection.btnLock_output_ftx.state
		ninexp.Lock_output_fsk = srFileSelection.btnLock_output_fsk.state
		ninexp.Lock_output_fvb = srFileSelection.btnLock_output_fvb.state
		ninexp.Lock_output_fcl = srFileSelection.btnLock_output_fcl.state
		ninexp.Lock_output_fts = srFileSelection.btnLock_output_fts.state
		ninexp.Lock_output_ftp = srFileSelection.btnLock_output_ftp.state
		ninexp.Lock_output_fsh = srFileSelection.btnLock_output_fsh.state
		ninexp.Lock_output_fsn = srFileSelection.btnLock_output_fsn.state


		ninexp.Lock_compress_bone = srOptimization.btnLock_compress_bone.state
		ninexp.Lock_unite_child = srOptimization.btnLock_unite_child.state
		ninexp.Lock_compress_material = srOptimization.btnLock_compress_material.state
		ninexp.Lock_compress_shape = srOptimization.btnLock_compress_shape.state


		ninexp.Lock_tolerance_translate = srToletance.btnLock_tolerance_translate.state
		ninexp.Lock_tolerance_rotate = srToletance.btnLock_tolerance_rotate.state
		ninexp.Lock_tolerance_scale = srToletance.btnLock_tolerance_scale.state

		ninexp.Lock_tolerance_tex_translate = srToletance.btnLock_tolerance_tex_translate.state
		ninexp.Lock_tolerance_tex_rotate = srToletance.btnLock_tolerance_tex_rotate.state
		ninexp.Lock_tolerance_tex_scale = srToletance.btnLock_tolerance_tex_scale.state

		ninexp.Lock_tolerance_color = srToletance.btnLock_tolerance_color.state


		ninexp.Lock_quantize_tolerance_translate = srQuantToletance.btnLock_quantize_tolerance_translate.state
		ninexp.Lock_quantize_tolerance_rotate = srQuantToletance.btnLock_quantize_tolerance_rotate.state
		ninexp.Lock_quantize_tolerance_scale = srQuantToletance.btnLock_quantize_tolerance_scale.state

		ninexp.Lock_quantize_tolerance_tex_translate = srQuantToletance.btnLock_quantize_tolerance_tex_translate.state
		ninexp.Lock_quantize_tolerance_tex_rotate = srQuantToletance.btnLock_quantize_tolerance_tex_rotate.state
		ninexp.Lock_quantize_tolerance_tex_scale = srQuantToletance.btnLock_quantize_tolerance_tex_scale.state
		
		ninexp.Lock_pre_export_script = srScript.btnLock_pre_export_script.state
		ninexp.Lock_post_export_script = srScript.btnLock_post_export_script.state
			
		if saveToScene do ninexp.SaveSetting()
	)
	
	fn doExport =
	(
		local ninexp = NintendoExport
		
		if srOutput.editFilename.text.count == 0 do
		(
			messageBox "Output File Name is wrong"
			return undefined
		)
		
		
		local fname = srOutput.editFilepath.text
		if not (pathConfig.isAbsolutePath fname) then
		(
			fname = pathConfig.convertPathToAbsolute  (pathConfig.appendPath maxFilePath fname)
		)
		
		if  not (doesFileExist fname) do
		(
			if  not (makeDir fname all:true) do
			(
				messageBox "Output Folder is wrong"
				return undefined
			)
		)
		
		/*
		if (srOutput.editFilename.text.count <= 0)do
		(
			messageBox "Output File Name is wrong"
			return undefined
		)
		*/
		
		-- time
		if (srAnimation.rdoTimeRange.state == 2) do
		(
			if(srAnimation.spnTimeStart.value > srAnimation.spnTimeEnd.value) do 
			(
				messageBox "Time Range is wrong"
				return undefined
			)
		)
		
		setWaitCursor()
		-- ΃pX\ɂ邽߁AeditFilepathɉς݂̐΃pXꎞIɓB
		local orgPath = srOutput.editFilepath.text
		srOutput.editFilepath.text = fname
		saveConfig saveToScene:utils.enableSaveToScene

		local ret = utils.checkOverwriteFiles (pathConfig.appendPath fname srOutput.editFilename.text)
		if not ret do
		(
			return undefined
		)
		
		ret = NintendoExport.doExport(srOutput.rdoSelection.state == 2)
		
		-- ̃pXɖ߂
		srOutput.editFilepath.text = orgPath
		saveConfig saveToScene:utils.enableSaveToScene
		utils.saveSettingDefault()
		
		setArrowCursor()
		removeTempPrompt()
		return ret
	)
	
	fn resizeAll =
	(
		local sHeight = 0
		for i = 1 to nintendoExportRollout.ro.rollouts.count do
		(
			local sro = nintendoExportRollout.ro.rollouts[i] 
			sHeight += 25
			sHeight += if sro.open then sro.height else -4
		)
		--sHeight = if sHeight < 700 then sHeight else 700
		nintendoExportRollout.ro.height = sHeight
		
		
		btnExport.pos.y = sHeight + 10
		btnApply.pos.y = sHeight + 10
		btnClose.pos.y = sHeight + 10
		nintendoExportRollout.height = sHeight + 40
	)
	
	fn setupIcon = 
	(
		local icon = #( \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 24 24 24), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 24 24 24), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 24 24 24), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 24 24 24), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 24 24 24), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 24 24 24), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 48 48 48), (color 0 0 0), (color 13 12 6), (color 215 191 62), (color 218 195 65), \
				(color 215 191 62), (color 13 12 6), (color 0 0 0), (color 48 48 48), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 48 48 48), \
				(color 0 0 0), (color 13 12 6), (color 215 191 62), (color 218 195 65), (color 215 191 62), (color 13 12 6), (color 0 0 0), (color 48 48 48), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 48 48 48), (color 0 0 0), (color 10 10 10), (color 149 149 149), (color 152 152 152), \
				(color 149 149 149), (color 10 10 10), (color 0 0 0), (color 48 48 48), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 12 12 12), (color 194 174 64), (color 192 171 58), (color 48 48 48), (color 0 0 0), \
				(color 48 48 48), (color 192 171 58), (color 194 174 60), (color 12 12 12), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 12 12 12), \
				(color 194 174 64), (color 192 171 58), (color 48 48 48), (color 0 0 0), (color 48 48 48), (color 192 171 58), (color 194 174 60), (color 12 12 12), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 12 12 12), (color 138 138 138), (color 134 134 134), (color 48 48 48), (color 0 0 0), \
				(color 48 48 48), (color 134 134 134), (color 136 136 136), (color 12 12 12), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 0 0 0), (color 213 190 61), (color 48 48 48), (color 16 16 16), (color 171 168 166), \
				(color 16 16 16), (color 48 48 48), (color 218 195 65), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 0 0 0), \
				(color 213 190 61), (color 48 48 48), (color 16 16 16), (color 171 168 166), (color 16 16 16), (color 48 48 48), (color 218 195 65), (color 0 0 0), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 0 0 0), (color 148 148 148), (color 48 48 48), (color 16 16 16), (color 168 168 168), \
				(color 16 16 16), (color 48 48 48), (color 152 152 152), (color 0 0 0), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 0 0 0), (color 217 194 64), (color 0 0 0), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 0 0 0), (color 217 194 64), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 0 0 0), \
				(color 217 194 64), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 0 0 0), (color 217 194 64), (color 0 0 0), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 0 0 0), (color 151 151 151), (color 0 0 0), (color 168 168 168), (color 168 168 168), \
				(color 168 168 168), (color 0 0 0), (color 151 151 151), (color 0 0 0), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 24 24 24), (color 16 16 16), (color 51 45 13), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 8 8 8), (color 96 96 96), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 24 24 24), (color 16 16 16), (color 51 45 13), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 8 8 8), (color 96 96 96), (color 171 168 166), (color 64 64 64), (color 0 0 0), (color 64 64 64), \
				(color 168 168 168), (color 168 168 168), (color 24 24 24), (color 16 16 16), (color 35 35 35), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 8 8 8), (color 96 96 96), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 0 0 0), (color 191 171 58), (color 194 173 57), (color 218 195 65), (color 218 195 65), (color 218 195 65), \
				(color 218 195 65), (color 218 195 65), (color 194 174 57), (color 191 171 58), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 0 0 0), (color 191 171 58), (color 194 173 57), (color 218 195 65), (color 218 195 65), (color 218 195 65), (color 218 195 65), \
				(color 218 195 65), (color 194 174 57), (color 191 171 58), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 0 0 0), (color 134 134 134), (color 135 135 135), (color 152 152 152), (color 152 152 152), (color 152 152 152), \
				(color 152 152 152), (color 152 152 152), (color 135 135 135), (color 134 134 134), (color 0 0 0), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 0 0 0), (color 190 169 56), (color 218 195 65), (color 218 195 65), (color 218 195 65), (color 77 68 20), \
				(color 215 191 62), (color 218 195 65), (color 218 195 65), (color 190 169 56), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 0 0 0), (color 190 169 56), (color 218 195 65), (color 218 195 65), (color 218 195 65), (color 77 68 20), (color 215 191 62), \
				(color 218 195 65), (color 218 195 65), (color 190 169 56), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 0 0 0), (color 132 132 132), (color 152 152 152), (color 152 152 152), (color 152 152 152), (color 52 52 52), \
				(color 149 149 149), (color 152 152 152), (color 152 152 152), (color 132 132 132), (color 0 0 0), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 0 0 0), (color 218 195 65), (color 218 195 65), (color 217 194 64), (color 51 45 13), (color 0 0 0), \
				(color 51 45 13), (color 215 191 62), (color 218 195 65), (color 218 195 65), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 0 0 0), (color 218 195 65), (color 218 195 65), (color 217 194 64), (color 51 45 13), (color 0 0 0), (color 51 45 13), \
				(color 215 191 62), (color 218 195 65), (color 218 195 65), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 0 0 0), (color 152 152 152), (color 152 152 152), (color 151 151 151), (color 35 35 35), (color 0 0 0), \
				(color 35 35 35), (color 149 149 149), (color 152 152 152), (color 152 152 152), (color 0 0 0), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 0 0 0), (color 217 194 64), (color 218 195 65), (color 218 195 65), (color 215 191 62), (color 77 68 20), \
				(color 215 191 62), (color 218 195 65), (color 218 195 65), (color 215 191 62), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 0 0 0), (color 217 194 64), (color 218 195 65), (color 218 195 65), (color 215 191 62), (color 77 68 20), (color 215 191 62), \
				(color 218 195 65), (color 218 195 65), (color 215 191 62), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 0 0 0), (color 151 151 151), (color 152 152 152), (color 152 152 152), (color 149 149 149), (color 52 52 52), \
				(color 149 149 149), (color 152 152 152), (color 152 152 152), (color 149 149 149), (color 0 0 0), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 0 0 0), (color 193 172 54), (color 204 180 53), (color 204 180 53), (color 204 180 53), (color 26 23 7), \
				(color 204 180 53), (color 204 180 53), (color 207 185 66), (color 193 172 54), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 0 0 0), (color 193 172 54), (color 204 180 53), (color 204 180 53), (color 204 180 53), (color 26 23 7), (color 204 180 53), \
				(color 204 180 53), (color 207 185 66), (color 193 172 54), (color 0 0 0), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 0 0 0), (color 133 133 133), (color 139 139 139), (color 139 139 139), (color 139 139 139), (color 18 18 18), \
				(color 139 139 139), (color 139 139 139), (color 146 146 146), (color 133 133 133), (color 0 0 0), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 0 0 0), (color 187 168 56), (color 186 166 55), (color 186 166 55), (color 186 166 55), (color 186 166 55), \
				(color 186 166 55), (color 186 166 55), (color 188 168 55), (color 187 168 56), (color 32 32 32), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 0 0 0), (color 187 168 56), (color 186 166 55), (color 186 166 55), (color 186 166 55), (color 186 166 55), (color 186 166 55), \
				(color 186 166 55), (color 188 168 55), (color 187 168 56), (color 32 32 32), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 0 0 0), (color 131 131 131), (color 130 130 130), (color 130 130 130), (color 130 130 130), (color 130 130 130), \
				(color 130 130 130), (color 130 130 130), (color 131 131 131), (color 131 131 131), (color 32 32 32), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 32 32 32), (color 64 64 64), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 64 64 64), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 32 32 32), (color 64 64 64), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 64 64 64), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 32 32 32), (color 64 64 64), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 64 64 64), (color 168 168 168), (color 168 168 168), (color 168 168 168)), \
			#((color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), (color 171 168 166), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), \
				(color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168), (color 168 168 168)) \
		)
		local icon_m = #(
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), \
				(color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
			#((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), \
				(color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)) \
		)
		
		
		local w = icon[1].count
		local h = icon.count
		lockIconMask
		lockIconMask
		lockIcon = bitmap icon[1].count icon.count
		for y = 1 to icon.count do
		(
			setPixels lockIcon [0, y-1] icon[y]
		)
		--display lockIcon
		
		lockIconMask = bitmap icon_m[1].count icon_m.count
		for y = 1 to icon_m.count do
		(
			setPixels lockIconMask [0, y-1] icon_m[y]
		)
		--display lockIconMask
		lockImages = #(lockIcon, lockIconMask, 3,2,1,2,3 )
	)
	
	fn filePostOpenCallback =
	(
		--print "fileopen"
		--print rootnode.custattributes.count
		if nintendoExportRollout.open do nintendoExportRollout.ro.visible = false
		if utils.enableSaveToScene do
		(
			local ca = rootnode.custattributes["NW4F Custom Attribute"]
			
			if ca != undefined do
			(
				NintendoExport.LoadSetting()	
				utils.saveSettingDefault()
			)
			--print "file open callback loadsave"
			--print rootnode.custattributes.count
		)
		if nintendoExportRollout.open do nintendoExportRollout.ro.visible = true
	)
	
	fn enableFilePostOpenCallback =
	(
		callbacks.removeScripts id:#nw4fFilePostOpen
		callbacks.addScript #filePostOpen "nintendoExportRollout.filePostOpenCallback()" id:#nw4fFilePostOpen
	)
	
	on nintendoExportRollout open  do
	(
		setupIcon()
		nintendoExportRollout.ro.visible = false
		AddSubRollout ro nintendoExportSR_Preset
		AddSubRollout ro nintendoExportSR_Output
		AddSubRollout ro nintendoExportSR_General
		AddSubRollout ro nintendoExportSR_Animation
		AddSubRollout ro nintendoExportSR_FileSelection
		AddSubRollout ro nintendoExportSR_Optimization
		AddSubRollout ro nintendoExportSR_Toletance
		AddSubRollout ro nintendoExportSR_QuantToletance
		--AddSubRollout ro nintendoExportSR_Quantization
		AddSubRollout ro nintendoExportSR_Script
		srPreset = ro.nintendoExportSR_Preset
		srOutput = ro.nintendoExportSR_Output
		srGeneral = ro.nintendoExportSR_General
		srFileSelection = ro.nintendoExportSR_FileSelection
		srOptimization = ro.nintendoExportSR_Optimization
		srAnimation = ro.nintendoExportSR_Animation
		srToletance = ro.nintendoExportSR_Toletance
		srQuantToletance = nintendoExportSR_QuantToletance
		srScript = nintendoExportSR_Script
		-- localizer
		--utils.nw4fExportDialogLocalizer nintendoExportRollout "ja"
		setLockInfo()
		
		-- restore roll state
		if 	NintendoExportRollout_subOpen.count == nintendoExportRollout.ro.rollouts.count do
		(
			for i = 1 to NintendoExportRollout_subOpen.count do
			(
				nintendoExportRollout.ro.rollouts[i].open = NintendoExportRollout_subOpen[i] as booleanClass
			)
		)
		resizeAll()
		
		nintendoExportRollout.utils.loadSettingDefault()
		loadConfig loadFromScene:utils.enableSaveToScene
		nintendoExportRollout.ro.visible = true
		
	)
	on nintendoExportRollout close  do
	(
		NintendoExportRollout_subOpen.count = nintendoExportRollout.ro.rollouts.count
		for i = 1 to NintendoExportRollout_subOpen.count do
		(
			NintendoExportRollout_subOpen[i] = nintendoExportRollout.ro.rollouts[i].open
		)
		NintendoExportRollout_height = nintendoExportRollout.height
	)
		
	on btnExport pressed  do
	(
		local ret = doExport()
		if ret == true then
		(
			DestroyDialog nintendoExportRollout
		)
		else if ret == false then
		(
			messageBox "Export Error!"
		)
		else if ret == undefined then
		(
			-- donothing
		)
	)
	on btnApply pressed  do
	(
		local ret = doExport()
		if ret == false then
		(
			messageBox "Export Error!"
		)
		else if ret == undefined then
		(
			-- donothing
		)
	)
	on btnClose pressed  do DestroyDialog nintendoExportRollout
) -- rollout



-- Plugin Version Dialog
rollout nw4fVersionRollout "NintendoExport 3ds Max Plugin Version" width:260 
(
	
	label lblMes1 "NintendoExport" align:#center 
	label lblMes2 "  " align:#center offset:[0,-4]
	label lblMes3 "Copyright (C)Nintendo Co., Ltd." align:#center --offset:[0,-6]
	label lblMes4 "All rights reserved." align:#center offset:[0,-4]
	label lblMes5 ""
	button btnOK "OK" width:80 --height:24
	
	on nw4fVersionRollout open do
	(
		local ninexp = NintendoExport
		if ninexp == undefined do return()
		local mes = ""
		mes += "3ds Max " + (((maxVersion())[1] / 1000 + 2000 - 2) as string)
		mes += " Plugin Ver " + ninexp.GetVersionString()
		lblMes2.text = mes
		--print mes
		setFocus nw4fVersionRollout.btnOK
	)
	on btnOK pressed  do DestroyDialog nw4fVersionRollout
)

-- save preset roolout
rollout nintendoExportSavePresetRollout "Save Preset" width:250--height:290
(
	radioButtons rdoSelectNew ""  labels:#("New") align:#left default:0 across:2
	editText editName ""  width:150 align:#right enabled:false
	
	radioButtons rdoSelectOverwrite ""  labels:#("Overwrite") align:#left default:1 across:2
	dropDownList ddlSelectPreset "" width:146 align:#right
	
	button btnSave "Save" width:80 offset:[0,10] across:2
	button btnCancel "Cancel" width:80  offset:[0,10]

	
	on rdoSelectNew changed val do
	(
		local isOn = val == 1
		rdoSelectNew.state = if isOn then 1 else 0
		rdoSelectOverwrite.state = if isOn then 0 else 1
		editName.enabled = isOn
		ddlSelectPreset.enabled = not isOn
		btnSave.enabled =  editName.text.count > 0
	)
	
	on rdoSelectOverwrite changed val do
	(
		rdoSelectOverwrite.state = if val == 1 then 1 else 0
		rdoSelectNew.state = if val == 1 then 0 else 1
		ddlSelectPreset.enabled = val == 1
		editName.enabled = val != 1
		btnSave.enabled = nintendoExportRollout.presetFiles.count > 0
	)
	
	on editName changed val do
	(
		btnSave.enabled = val.count > 0
	)
	
	fn savePresetFdes fname =
	(
		if doesFileExist fname do
		(
			local mes = "fdes file already exists.\n"
			mes += fname
			mes += "\nDo you want to replace it ?"
			if not (queryBox mes title:"Save Preset") do return false
		)
		if not (pathConfig.isLegalPath fname) do
		(
			local mes = "Illegal file name\n"
			mes = append mes fname
			messageBox mes
			return false
		)
		
		nintendoExportRollout.saveConfig saveToScene:false
		NintendoExport.PresetName = getFilenameFile fname
		if not (nintendoExportRollout.utils.saveSettingToFile fname) do
		(
			messageBox "fdes save error"
			return false
		)
		return true
	)
	
	on btnSave pressed  do 
	(
		local fpath = nintendoExportRollout.presetsPath 
		if fpath == undefined or not (doesFileExist fpath)then
		(
			messagebox "Preset path not found"
		)
		else
		(
			local fname = ""
			if rdoSelectNew.state == 1 then
			(
				if editName.text.count > 0 then
				(
					if (nintendoExportRollout.utils.isValidPresetName editName.text showMsgBox:true )then
					(
						fname = pathConfig.appendPath fpath (editName.text  + @".fdes")
						if not (savePresetFdes fname) do return()
					)
					else
					(
						--messagebox "Preset Name is wrong\n (please don't use [non acsii character] [;] [:] [/] [\\] [*] [?] [<] [>] [|] [double quote] [None])"
						return()
					)
				)
				else
				(
					messagebox "Please enter preset name"
					return()
				)
			)
			else -- overwrite
			(
				local files = nintendoExportRollout.presetFiles
				if files.count == 0 or ddlSelectPreset.selection == 0 or ddlSelectPreset.selection > files.count do
				(
					messagebox "Preset file not found"
					return()
				)
				fname = files[ddlSelectPreset.selection]
				if not (savePresetFdes fname) do return()
			)
			nintendoExportRollout.listUpPreset()
			nintendoExportRollout.setPresetDDL (getFilenameFile fname)
		)
		DestroyDialog nintendoExportSavePresetRollout
	)
	
	on nintendoExportSavePresetRollout open do 
	(
		local ddl = ddlSelectPreset
		--local ddlsel = ddl.selection
		--ddl.enabled  = false
		
		local presets = #()
		for f in nintendoExportRollout.presetFiles do
		(
			presets = append presets (getFilenameFile f)
		)
		ddl.items = presets
		if presets.count == 0 do
		(
			rdoSelectNew.changed 1
		)
	)
	
	on btnCancel pressed  do DestroyDialog nintendoExportSavePresetRollout
)

-----------------------------------------------------
-- main menu
rcMenu nintendoExportSettingMenu 
(
	subMenu "Settings" 
	(
		menuItem mi_scene "Save / Load Scene Settings" checked:false
		menuItem mi_deleteScene "Delete Scene Settings"
		--menuItem mi_revertScene "Revert to Original Scene Settings"
		separator sep1
		menuItem mi_resetScene "Reset Settings"
		menuItem mi_saveScene "Save Settings"
		separator sep2
		menuItem mi_loadFile "Load Settings from fdes File..."
		menuItem mi_saveFile "Save Settings to fdes File..."
		separator sep3
		menuItem mi_lockAll "Lock All Settings" enabled:false
		menuItem mi_unlockAll "Unlock All Settings" enabled:false
		separator sep4
		menuItem mi_presetFolder "Open Presets Folder..."
	)
	
	subMenu "Help" 
	(
		menuItem mi_Help "Help On Export..."
	)
	on mi_Help picked do nintendoExportRollout.showHelp @"html\export.html"
	
	/*
	subMenu "Language" 
	(
		menuItem mi_langEn "English"
		menuItem mi_langJa "Japanese"
	)
	*/
	
	fn updateMenu isEn:true =
	(
		mi_scene.checked = nintendoExportRollout.utils.enableSaveToScene
		if nintendoExportRollout.open do
		(
			mi_lockAll.enabled = mi_unlockAll.enabled = nintendoExportRollout.srPreset.chkEdit.state
		)
		/*print isEn
		mi_scene.text = 			if isEn then "Save/Load Scene Settings" else "oݒ̕ۑ/ǂݍ"
		mi_resetScene.text = 	if isEn then  "Reset Scene Settings" else "oݒ̃Zbg"
		mi_deleteScene.text = 	if isEn then  "Delete Scene Settings " else "oݒ̍폜"
		mi_loadFile.text = 		if isEn then  "Load Settings from fdes File" else "ǂݍ"
		mi_saveFile.text = 		if isEn then  "Save Settings to fdes File" else "ۑ"
		*/	
	)
	
	
	on mi_langEn picked do
	(
		(NintendoExportUtilities()).nw4fExportDialogLocalizer nintendoExportRollout "en"
		updateMenu isEn:true
	)
	on mi_langJa picked do
	(
		(NintendoExportUtilities()).nw4fExportDialogLocalizer nintendoExportRollout "ja"
		updateMenu isEn:false
	)
	
	on mi_scene picked do
	(
		local val = nintendoExportRollout.utils.enableSaveToScene
		nintendoExportRollout.utils.enableSaveToScene = not val
		nintendoExportRollout.utils.saveSettingConfig()
		updateMenu()
	)
	
	on mi_deleteScene picked do
	(
		if (queryBox "Delete Settings?") do
		(
			deleteItem rootnode.custattributes "NW4F Custom Attribute"
			nintendoExportRollout.loadConfig loadFromScene:false
			updateMenu()
		)
	)
	
	on mi_revertScene picked do
	(
		if (queryBox "Revert to Original Scene Settings?") do
		(
			nintendoExportRollout.loadConfig loadFromScene:true
			updateMenu()
		)
	)

	on mi_resetScene picked do
	(
		if (queryBox "Reset Settings?") do
		(
			NintendoExport.ResetSetting()
			nintendoExportRollout.loadConfig loadFromScene:false
			updateMenu()
		)
	)
	on mi_saveScene picked do
	(
		nintendoExportRollout.saveConfig saveToScene:nintendoExportRollout.utils.enableSaveToScene
		nintendoExportRollout.utils.saveSettingDefault()
		updateMenu()
	)

	on mi_saveFile picked do
	(
		local fname = getSaveFileName caption:"Save Setting File" types:"Settings(*.fdes)|*.fdes|All|*.*|" historyCategory:"NW4F_Setting_File"
		if (fname != undefined) do
		(
			nintendoExportRollout.saveConfig saveToScene:false
			if not (nintendoExportRollout.utils.saveSettingToFile fname) do
			(
				messageBox "fdes save error"
			)
		)
	)
	on mi_loadFile picked do
	(
		local fname = getOpenFileName caption:"Load Setting File" types:"Settings(*.fdes)|*.fdes|All|*.*|" historyCategory:"NW4F_Setting_File"
		if (fname != undefined) do
		(
			if not (nintendoExportRollout.utils.loadSettingFromFile fname) do
			(
				messageBox "fdes load error"
			)
			if NintendoExport.presetName.count > 0 do
			(
				nintendoExportRollout.utils.loadPresetByName NintendoExport.presetName
			)
			nintendoExportRollout.loadConfig loadFromScene:false
		)
	)
	on mi_presetFolder picked do
	(
		local pPath = nintendoExportRollout.utils.getPresetsFolder()
		if pPath != undefined and doesFileExist pPath do
		(
			ShellLaunch pPath ""
			DestroyDialog nintendoExportRollout		
		)
	)
	on mi_lockAll picked do nintendoExportRollout.lockAll true
	on mi_unlockAll picked do nintendoExportRollout.lockAll false
	
	on nintendoExportSettingMenu open do updateMenu()
	on nintendoExportSettingMenu update do updateMenu()
)

macroScript nw4fMS_ExportWithSetting category:"Nintendo"
(
	on execute do 
	(
		CreateDialog  nintendoExportRollout menu:nintendoExportSettingMenu --height:NintendoExportRollout_height --modal:true 
		setFocus nintendoExportRollout
	)
)

macroScript ResetExportSetting category:"Nintendo"
(
	on execute do 
	(
		local ret = queryBox "Reset Export Setting?" title:"confirm reset"
		if ret do
		(
			NintendoExport.ResetSetting()
			NintendoExport.SaveSetting()
		)
	)
)

macroScript nw4fMS_ExportNow category:"Nintendo" 
(
	on execute do 
	(
		local ninexp = NintendoExport
		local utils = NintendoExportUtilities()
		utils.loadSettingConfig()
		utils.loadSettingDefault()
		
		if utils.enableSaveToScene do ninexp.LoadSetting()
		
		local fname = ninexp.outputFolder

		if not (pathConfig.isAbsolutePath fname) then
		(
			fname = pathConfig.convertPathToAbsolute  (pathConfig.appendPath maxFilePath fname)
		)

		if  not (doesFileExist fname) do
		(
			messageBox "Output Folder is wrong"
			return false
		)
		
		ret = utils.checkOverwriteFiles (pathConfig.appendPath fname ninexp.filename)
		if not ret do
		(
			return false
		)
		
		if (ninexp.filename.count <= 0)do
		(
			messageBox "Output File Name is wrong"
			return false
		)
		
		setWaitCursor()
		local orgPath = ninexp.outputFolder
		ninexp.outputFolder = fname
	
		ret = ninexp.doExport ninexp.doesExportSelected
		
		ninexp.outputFolder = orgPath
		setArrowCursor()
		removeTempPrompt()

		if not ret do
		(
			messageBox "Export error!"
		)
	)
)

macroScript nw4fMS_MultiExport category:"Nintendo"
(
	on execute do 
	(
		CreateDialog  nw4fMultiExportRollout menu:nw4fMultiExportMenu --height:NintendoExportRollout_height --modal:true 
		setFocus nw4fMultiExportRollout
	)
)


macroScript nw4fMS_SetNoCompressNode category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fNodeRollout menu:nw4fNodeMenu
		setFocus nw4fNodeRollout
	)
)
macroScript nw4fMS_SetBillboard category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fBillboardRollout
		setFocus nw4fBillboardRollout
	)
)

macroScript nw4fMS_SetMaterial category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fMaterialRollout menu:nw4fMaterialMenu
		setFocus nw4fMaterialRollout
	)
)

macroScript nw4fMS_SetSampler category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fSamplerRollout menu:nw4fSamplerMenu
		setFocus nw4fSamplerRollout
	)
)

macroScript nw4fMS_SetRenderPriority category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fRenderPriorityRollout
		setFocus nw4fRenderPriorityRollout
	)
)

macroScript nw4fMS_SetCombineGroup category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fCombineRollout
		setFocus nw4fCombineRollout
	)
)

macroScript nw4fMS_SetForceExportKey category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fForceKeyRollout
		setFocus nw4fForceKeyRollout
	)
)

macroScript nw4fMS_SetNodeUserData category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fNodeUserDataRollout menu:nw4fNodeUserDataMenu
		setFocus nw4fNodeUserDataRollout
	)
)

macroScript nw4fMS_SetShapeAnimation category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fShapeAnimRollout menu:nw4fShapeAnimMenu
		setFocus nw4fShapeAnimRollout
	)
)

macroScript nw4fMS_HelpIndex category:"Nintendo" 
(
	on execute do 
	(
		nintendoExportRollout.showHelp @"3dsmaxPlugin.html"
	)
)

macroScript nw4fMS_PluginVersion category:"Nintendo" 
(
	on execute do 
	(
		CreateDialog  nw4fVersionRollout modal:true --style:#(#style_titlebar, #style_border)
		setFocus nw4fVersionRollout
		
	)
)


	
fn getNintendoExportMenu =
(
	local mainMenuBar = menuman.getMainMenuBar()

	-- NW4F j[폜
	for i = mainMenuBar.numitems() to 1 by -1 do 
	(
		local mi = mainMenuBar.getItem i
		if ( (mi.getTitle()) == "NW4F" ) do
		(
			mainMenuBar.removeItemByPosition i
		)
	)


	local flagFind = false
	local i = 1

	while (i <= mainMenuBar.numitems() and (not flagFind)) do
	(
		local mi = mainMenuBar.getItem i
		if ( (mi.getTitle()) == "Nintendo" ) do
		(
			return mi
		)
		i += 1
	)
	-- Nintendoj[o^
	local subMenu = menuMan.createMenu "Nintendo"
	local subMenuItem = menuMan.createSubMenuItem "Test Menu" subMenu
	-- C j[ o[̍Ōォ 2 Ԗڂ̃j[ڂ̃CfbNXvZ܂B
	local subMenuIndex = mainMenuBar.numItems() - 1
	-- Tuj[Ōォ 2 Ԗڂ̃Xbgɒǉ܂B
	mainMenuBar.addItem subMenuItem subMenuIndex
	return subMenuItem
)

fn nw4fAppendMenu menu macro menuname = 
(
	if macro.count == 0 do
	(
		menu.addItem (menuMan.createSeparatorItem()) -1
		return()
	)
	local dialogItem = menuMan.createActionItem macro "Nintendo"
	dialogItem.setTitle menuname
	dialogItem.setUseCustomTitle true
	menu.addItem dialogItem -1
)

fn resetMenuActions mi =
(
	local menu = mi.getSubMenu()
	-- ܂o^ς݂̃Tuj[ACe폜
	while (menu.numItems() > 0) do
	(
		menu.removeItemByPosition 1
	)
	
	--local dialogItem 

	nw4fAppendMenu menu "nw4fMS_ExportNow" "Export"
	nw4fAppendMenu menu "nw4fMS_ExportWithSetting" "Export With Setting..."
	nw4fAppendMenu menu "nw4fMS_MultiExport" "Multi Export..."
	
	nw4fAppendMenu menu "" ""

	nw4fAppendMenu menu "nw4fMS_SetMaterial" "Set Material Attribute..."
	nw4fAppendMenu menu "nw4fMS_SetSampler" "Set Sampler Attribute..."
	
	nw4fAppendMenu menu "" ""

	nw4fAppendMenu menu "nw4fMS_SetNoCompressNode" "Set No Compress Node..."
	nw4fAppendMenu menu "nw4fMS_SetNodeUserData" "Set User Data..."

	nw4fAppendMenu menu "" ""

	nw4fAppendMenu menu "nw4fMS_SetShapeAnimation" "Set Shape Animation..."
	
	nw4fAppendMenu menu "" ""
	
	nw4fAppendMenu menu "nw4fMS_HelpIndex" "Help Index..."
	nw4fAppendMenu menu "nw4fMS_PluginVersion" "Plugin Version..."
	
)

fileIn  "NintendoExportNodeOptions.ms.inc"
fileIn  "NintendoExportMaterialOptions.ms.inc"


----------------------------------------------
-- Main

fn NintendoExportMain =
(
	-- Cj[Nintendoj[ǉ	
	local nw4fMenu = getNintendoExportMenu()
	resetMenuActions nw4fMenu
	-- }eAGfB^Nintendoj[ǉ	
	local nw4fMtlMenu = getNw4fMtlMenu()
	resetMtlMenuActions nw4fMtlMenu
	
	nintendoExportRollout.utils.loadSettingDefault()
	nintendoExportRollout.enableFilePostOpenCallback()
	
	menuMan.updateMenuBar()
)

-- NintendoExport vOCǂݍ܂ĂȂꍇ͉ȂB
if NintendoExport != undefined do
(
	NintendoExportMain()
)


fn nw4fUseDisableZYAxisConversion val = 
(
	nintendoExportRollout.utils.loadSettingConfig()
	nintendoExportRollout.utils.showDisableZYAxisConversion = if val == true then true else false
	nintendoExportRollout.utils.saveSettingConfig()
)

fn nw4fDeleteAllCustomAttribute = 
(
	
	--if not (queryBox "Delete All Nintendo Custom Attributes.\nContinue?") do return false
		
	-- delete node custom attributes
	for n in objects do
	(
		local attrib = n.custAttributes["NW4F Node Custom Attribute"]
		if attrib != undefined do 
		(
			deleteItem n.custAttributes "NW4F Node Custom Attribute"
			format "delete node attribute (%)\n" n.name
		)
	)
	
	-- delete materila custom attributes
	for n in objects do
	(
		local mtl = n.material
		if mtl != undefined do
		(
			local attrib = mtl.custAttributes["NW4F Material Custom Attribute"]
			if attrib != undefined then
			(
				deleteItem mtl.custAttributes "NW4F Material Custom Attribute"
				format "delete mtl attribute (%)\n" mtl.name
			)
			
			if(classOf mtl == Multimaterial) do
			(
				for submtl in mtl.materialList do
				(
					local attrib = submtl.custAttributes["NW4F Material Custom Attribute"]
					if attrib != undefined then
					(
						deleteItem submtl.custAttributes "NW4F Material Custom Attribute"
						format "delete mtl attribute (%)\n" submtl.name
					)
				)
			)
		)
	)
)
