﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// max headers
#include "3dsmaxsdk_preinclude.h"
#pragma warning(disable : 4819) // disable unicode warning
#include "Max.h"
#include "iparamb2.h"
#include "iparamm2.h"
#include "stdmat.h"
#include "IPathConfigMgr.h"
#include "Path.h"
#include "imtl.h"

#include "iskin.h"
#include "cs\Phyexp.h"
#include "cs\bipexp.h"
#include "MeshNormalSpec.h"
#include "CustAttrib.h"
#include "ICustAttribContainer.h"
#include "decomp.h"

#pragma warning(disable : 4996) // disable swprintf warning
#pragma warning(disable : 4100) // disable no refer warning
#pragma warning(disable : 4245) // disable no refer warning
#include "wm3.h"
#pragma warning(default: 4245) // recover no refer warning
#pragma warning(default: 4100) // recover no refer warning
#pragma warning(default: 4996) // recover swprintf warning
#pragma warning(default: 4819) // recover unicode warning


// stdlib headers
#include <vector>

// utility headers
#include "DccUtilityShape.h"
#include "DccUtilityNode.h"
#include "DccUtilityModel.h"
#include "DccUtilitySceneLights.h"
#include "DccUtilitySceneCameras.h"

#include "MaterialInfo.h"

// FDC Headers
#include "DccCommon.h"

//using namespace std;
//using namespace utility;

// define
class CNodeTree;
typedef vector<CNodeTree*> nodeTreeList;
typedef vector<INode*> maxNodeList;
typedef vector<nn::gfx::tool::dcc::utility::RNode*> rNodeList;
typedef map<INode*, nn::gfx::tool::dcc::utility::RNode*> INodeToRNodeMap;


typedef pair<int, float> skinWeight;
typedef vector<skinWeight> skinVtxInfo;
typedef vector<skinVtxInfo> skinVtxInfoList;

typedef std::vector<nn::gfx::tool::dcc::RMtx44> RMtx44Array;

typedef std::map<int,int> intintmap;

struct maxUVInfo
{
    int cafeUV;
    int maxUV;
    string maxUVName;
    bool useForce;
};
typedef std::vector<maxUVInfo> cafeToMaxUVInfoVec;


nn::gfx::tool::dcc::RMtx44 maxMtxToRMtx(const Matrix3 tm);
class CNodeTree
{
public:
    // ノードの名前
    string m_Name;

    // 子ノード
    nodeTreeList m_Children;

    // Node情報
    CNodeTree* m_pParent;
    INode* m_pMaxNode;
    INode* m_pMaxParent;
    nn::gfx::tool::dcc::utility::RNode* m_pRNode;
    nn::gfx::tool::dcc::utility::RNode* m_pRParent;

    // 表示情報
    bool m_IsVisible;
    bool m_IsNoCompress;
    UINT m_BillboardType;
    int	 m_CombineGroup;
    bool m_DoesExportModel;
    string m_UserOptions;


    // ボーン情報
    bool m_IsBone;
    nn::gfx::tool::dcc::RMtx44 m_InitMtx, m_InitLocalMtx;

    // スキニング情報
    skinVtxInfoList m_SkinVtx;
    INodeTab m_MaxBones;
    rNodeList m_RBones;
    RMtx44Array m_BonesInitMtx;

    // skin modifier
    Modifier* m_pSkinMod;

    // morph
    MorphR3* m_pMorphMod;
    IntTab m_MorphCh;
    INodeTab m_MorphTargetNodes;

    bool m_ExportShapePosition;
    bool m_ExportShapeNormal;
    bool m_ExportShapeColor;

    // object
    TriObject* m_pTriObj;
    bool m_IsNeedDelTriObj;

    // uv
    //nn::gfx::tool::dcc::RStringArray	m_UvAttribNames; //!< 各 UV セットの頂点属性名配列です。空文字ならヒント情報インデックスから決定します。
    //nn::gfx::tool::dcc::RIntArray		m_UvHintIdxs; //!< 各 UV セットのヒント情報インデックス配列です。

    // user data



    // 強制的にアニメーションキーを出力するかどうか
    bool m_DoesExportScaleKey;
    bool m_DoesExportRotateKey;
    bool m_DoesExportTransKey;
    bool m_DoesExportVisibility;

public:
    void SetName(string n){ m_Name = n; };
    string GetName(void){ return m_Name;};

    CNodeTree(void);
    CNodeTree(CNodeTree* node);
    ~CNodeTree(void);
    // 初期化
    void Init(void);

    // ノードを設定する。
    void SetNode(INode* node, string name = "");

    // ノードをINodeをキーに検索する。
    CNodeTree* FindChild(INode* node);

    // ノードをINodeをキーに再帰的に検索する。
    CNodeTree* FindChildRecursive(INode* node);

    // ノードを逆に辿り、ルートノードを探す
    CNodeTree* FindRootNode()
    {
        if(m_pParent)
        {
            return m_pParent->FindRootNode();
        }
        return this;
    }


    // 子にノードを追加
    CNodeTree* AddChild(INode*);

    // 指定のノード以下を再帰的に登録する。
    void AddChildrenRecursive();

    // INodeが適切なノードかどうか
    bool IsValidINode(INode* node)
    {
        return (node && node->GetParentNode());
        //return (node != NULL);
    };

    // 指定された期間のSRTアニメーションを設定する
    bool SetAnimation(int start, int end, int frameTicks);

    // 再帰的に指定された期間のSRTアニメーションを設定する
    bool SetAnimationRecursive(int start, int end, int frameTicks);

    // 再帰的に指定された期間のビジビリティアニメーションを設定する
    bool SetVisibilityAnimationRecursive(int start, int end, int frameTicks);

    // 再帰的に指定された期間のシェイプアニメーションを設定する。
    bool SetShapeAnimationRecursive( int start, int end, int frameTicks );

    // モデルとして調査する
    bool InquiryAsModel(void);

    // ノードからオブジェクトを取り出す
    bool PerpareObject(void);

    // モディファイア適用前のObjectを取得
    Object* GetObjBeforeModifier();

    // モディファイアからスキンの情報を取得する。
    bool GetSkinInfoFromModifier(Modifier* mod);

    // RNodeを再帰的に作成する。
    void CreateRNodeRecursive(CNodeTree* parent, INodeToRNodeMap& nodeMap, int f);

    // RModelを再帰的に作成する。
    bool CreateRModelRecursive(CNodeTree* parent, nn::gfx::tool::dcc::utility::RSceneMaterials& sceneMaterials, INodeToRNodeMap& nodeMap, std::vector<nn::gfx::tool::dcc::utility::RNode*>& bones, nn::gfx::tool::dcc::RExpOpt& rOpt);

    int findValidCh(cafeToMaxUVInfoVec &cafeUVToMaxUV, int maxCh);

    //void getCafeVColToMaxVColMap( intintmap &cafeColToMaxCol, Mesh* mesh );

    // スキン適用時のバインドポーズの行列をワールド座標系で返す。
    nn::gfx::tool::dcc::RMtx44 GetWorldInitMtx()
    {
        if(m_IsBone) return m_InitMtx;
        return maxMtxToRMtx(m_pMaxNode->GetNodeTM(0));
    }

    // 現在の姿勢をバインドポーズに上書きする。
    void SetInitMtxFromCurrentTM();

    // Physiqueからノードのバインド行列を再帰的に取り出す
    void ResolvePhysiqueInitMtxRecursive(CNodeTree* node, IPhysiqueExport* phyExport = NULL);

    // Physiqueからノードのバインド行列を再帰的に取り出す
    void ResolvePhysiqueInitMtxRecursiveAll(CNodeTree* root);

    // ボーンに挟まれたボーンでないノードを再帰的に調べて返す。
    void CheckNonBoneIsExistBetweenBonesRecursive(nodeTreeList& node);

    // ボーンに挟まれたボーンでないノードか調べる。
    bool IsNonBoneIsExistBetweenBones();

    // ライトを再帰的に作成する
    void setLightsRecursive(nn::gfx::tool::dcc::utility::RSceneLights &lights, int start, int end, int frameTicks);

    // カメラを再帰的に作成する(アニメーションも)
    void SetCamerasRecursive(nn::gfx::tool::dcc::utility::RSceneCameras &cameras, int start, int end, int frameTicks);

    // 量子化タイプ設定
    /*
    static nn::gfx::tool::dcc::RExpOpt::Quantize m_QuantPos_, m_QuantNml_, m_QuantTex_;
    static void SetQuantizeType(nn::gfx::tool::dcc::RExpOpt::Quantize qPos, nn::gfx::tool::dcc::RExpOpt::Quantize qNml, nn::gfx::tool::dcc::RExpOpt::Quantize qTex)
    {
        m_QuantPos_ = qPos;
        m_QuantNml_ = qNml;
        m_QuantTex_ = qTex;
    }
    */

    static bool m_UseFigureMode;
    static void SetUseFigureMode(bool flag)
    {
        m_UseFigureMode = flag;
    }
    static bool m_ConvertToModel_;
    static void SetConvertToModel(bool flag)
    {
        m_ConvertToModel_ = flag;
    }
    static bool m_NonUniformScale_;
    static int m_ReservedUniformRegister_;
    static void SetUniformRegisterInfo(bool flag, int numreg)
    {
        m_NonUniformScale_ = flag;
        m_ReservedUniformRegister_ = numreg;
    }
    void GetCamerasRecursive( INodeTab& camNodes);

    bool GetSkinModFromNode();
    bool GetMorphFromNode();
    bool checkMorphTagetValidity();
    bool GetGeomVertex(Mesh* mesh, nn::gfx::tool::dcc::utility::RModel &multiMateShape, cafeToMaxUVInfoVec& cafeUVToMaxUV, intintmap& cafeColToMaxCol );
    bool ExportGeomObject( Mesh* mesh, nn::gfx::tool::dcc::utility::RModel &multiMateShape, std::vector<int>& VtxMtxIdxs, nn::gfx::tool::dcc::utility::RSceneMaterials &sceneMaterials, MultiMtlInfo& multiMtl, cafeToMaxUVInfoVec& cafeUVToMaxUV, intintmap& cafeColToMaxCol );

    bool GetStandardVCol( int numVcFaces, TVFace** vcFaces, VertColor** vcVerts, nn::gfx::tool::dcc::RVec4Array* col_array, nn::gfx::tool::dcc::RVec4Array* basecol_array = nullptr);

    // メッシュから法線を取り出す
    // basenml_arrayが指定されているとき、メッシュの法線と比較する
    // 法線が全て一致した場合はfalseを返す
    bool GetNormals( Mesh* mesh, nn::gfx::tool::dcc::RVec3Array* nml_array, nn::gfx::tool::dcc::RVec3Array* basenml_array = nullptr);
    void CollectMorphTargetRecursive( INodeTab& morphTargets );
    void HideMorphTargetRecursive( INodeTab& morphTargets );

    enum vc_type {
        vc_color = 0,
        vc_shade,
        vc_alpha,
    };
};

class CSceneNode
{
public:
    CNodeTree m_Root;
    //INode* maxRoot;
    //RNode* rRoot;
    INodeToRNodeMap m_INodeToRNode;



    CSceneNode(void){ Init(); }

    void Init(){m_Root.Init();}
    ~CSceneNode(void)
    {
        if(m_Root.m_pRNode)
        {
            delete m_Root.m_pRNode;
        }
        m_Root.Init();
    };

    // 渡されたノード以下を登録する(初期化される)
    void RecursiveAddNodes(INode* root);

    // ノードをツリーに追加する。
    // underRootがtrueの場合は、シーンルート直下に追加。
    // falseの場合は親ノードが追加されていない場合は親ノードを再帰的に追加する。
    CNodeTree* AddNodeInTree(INode* node, bool underRoot = false);

    // ノードをツリーから探す。
    CNodeTree* FindNodeInTree(INode* node);

    // ルートノードを設定
    void SetRootNode(INode* node)
    {
        m_Root.Init();
        m_Root.SetNode(node, "nw4f_root");
    }

    // ルートノードを取得
    CNodeTree* GetRootNode()
    {
        return &m_Root;
    }

    // 登録されたノードからボーンを探し、それも登録する。
    void AddAllBones(){ SddBonesInTree(&m_Root); };

    // 全ての登録されたノードにスキンで必要なボーンが有るかどうか調べる。
    bool IsAllBonesExists(){ return IsBonesExists(&m_Root);	}

    // 階層内にボーンに挟まれたボーンでないノードを調べて返す。
    void CheckNonBoneIsExistBetweenBones(nodeTreeList& node);

    // エクスポート用にRNode等を準備する。
    bool PrepareExport( void );
    //	シーン中のノードを処理する
    bool ProcessNodes( int f = 0 );
    //	シーン中のモデルを処理する
    bool ProcessModels(nn::gfx::tool::dcc::utility::RSceneMaterials &sceneMaterials, std::vector<nn::gfx::tool::dcc::utility::RNode*>& bones, nn::gfx::tool::dcc::RExpOpt& rOpt );

    //	モーフターゲットは表示しないようにする
    void HideMorphTargets(std::vector<nn::gfx::tool::dcc::utility::RNode*> Nodelist);

    //全てのノードに指定された期間のアニメーションを設定する。
    void SetAnimations(int start, int end, int frameTicks);

    //全てのノードに指定された期間のビジビリティアニメーションを設定する。
    void SetVisibilityAnimations(int start, int end, int frameTicks);

    //全てのノードに指定された期間のシェイプアニメーションを設定する。
    void SetShapeAnimations(int start, int end, int frameTicks);

    // 登録されたノードからライトを作成する。
    void setLights(nn::gfx::tool::dcc::utility::RSceneLights &lights, int start, int end, int frameTicks);

    // 登録されたノードからカメラを作成する。
    void SetCameras(nn::gfx::tool::dcc::utility::RSceneCameras &cameras, int start, int end, int frameTicks);
#if !defined( NW4F_C3T_DELETE )
    // 登録されたノードからフォグを作成する。
    void setFogs( FSceneFogs& sceneFog, int subStart, int subEnd, int ticks );
#endif
    /**
    ノード名の重複を解消する。
    \par 解説：
    　ノード名の重複を解消する。
    */
    bool SetNamesUnique(void);

private:
    // ボーンをツリーに追加
    void SddBonesInTree(CNodeTree* cNode);
    // 登録されたノードにスキンで必要なボーンが有るかどうか調べる。
    bool IsBonesExists(CNodeTree* cNode);
};
