﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "3dsmaxsdk_preinclude.h"
#pragma warning(disable : 4819) // disable unicode warning
#include "Max.h"
#include "iparamb2.h"
#include "iparamm2.h"
#include "IPathConfigMgr.h"
#include "Path.h"
#include "imtl.h"
#include "stdmat.h"
#include "shaders.h"
#include "CustAttrib.h"
#include "ICustAttribContainer.h"
#pragma warning(default: 4819) // recover unicode warning

#if (MAX_VERSION_MAJOR >= 12) // max2010以降
    #include "IFileResolutionManager.h"
#endif

#include <iostream>
#include <iomanip>
#include <fstream>
#include <strstream>
#include <vector>


#include "DccUtilityShape.h"
#include "DccUtilitySceneMaterials.h"
#include "DccUtilityLogger.h"

#define GNORMAL_CLASS_ID	Class_ID(0x243e22c6, 0x63f6a014)


//using namespace nn::gfx::tool::dcc::utility;

class MtlInfo
{
public:
    Color	m_Diffuse;
    Color	m_Ambient;
    Color	m_Specular;
    Color	m_Emittion;
    float	m_Transparency;
    float	m_Shiness;
    float	m_ShineLevel;
    string	m_Name;
    Mtl*	m_pMaxMtl;
    Mtl*	m_pParentMaxMtl;
    bool	m_HasBump;
    int		m_BumpTexIdx;
    int		m_BumpTexCh;

    bool	m_HasBitmapAlpha;
    bool	m_HasVtxAlpha;
    bool	m_VtxAlphaUpdated;

    bool	m_IsAnisotropic;

    // マテリアルに含まれるビットマップの情報
    struct MaxBitmapInfo
    {
        BitmapTex*	bmtex;
        int			mapch;
        CStr		filename;
        CStr		name;
        bool		isBump;
        bool		isAlpha;
        bool		isIFL;
        nn::gfx::tool::dcc::RSampler::Hint	hint;
#if !defined( NW4F_C3T_DELETE )
        RImage*		rImage;
#endif
    };

    std::vector<MaxBitmapInfo> m_BitmapArray;
    std::vector<MaxBitmapInfo> m_AnimMapArray[3];


    MtlInfo()
        : m_Transparency(0.0f), m_pMaxMtl(NULL), m_pParentMaxMtl(NULL), m_HasBump(false)
        , m_BumpTexIdx(-1), m_BumpTexCh(-1), m_HasBitmapAlpha(false)
        , m_Shiness(0.0f), m_ShineLevel(0.0f), m_IsAnisotropic(false)
        , m_HasVtxAlpha(false), m_VtxAlphaUpdated(false)
    {
        m_Diffuse.White();
        m_Ambient.White();
        m_Specular.White();
        m_Emittion.Black();
        m_BitmapArray.clear();
        for(int i = 0; i < 3; i++) { m_AnimMapArray[i].clear(); }
    }

    //MtlInfo(Mtl* mtl, bool exportTex){ Init(mtl); };
    ~MtlInfo();

    bool Init(Mtl* mtl);

    // マテリアル名の取得
    string GetName() { return m_Name; }

    // 各種カラーの取得
    nn::gfx::tool::dcc::RVec4 GetDiffuse() { return nn::gfx::tool::dcc::RVec4(m_Diffuse.r, m_Diffuse.g, m_Diffuse.b, m_Transparency); }
    nn::gfx::tool::dcc::RVec4 GetAmbient() { return nn::gfx::tool::dcc::RVec4(m_Ambient.r, m_Ambient.g, m_Ambient.b, 0.0f); }
    nn::gfx::tool::dcc::RVec4 GetSpecular() { return nn::gfx::tool::dcc::RVec4(m_Specular.r, m_Specular.g, m_Specular.b, 0.0f); }
    nn::gfx::tool::dcc::RVec4 GetEmittion() { return nn::gfx::tool::dcc::RVec4(m_Emittion.r, m_Emittion.g, m_Emittion.b, 0.0f); }

    // 透明度の判定
    bool IsTransparent() {return (m_HasBitmapAlpha || (fabsf(m_Transparency - 1.0f) > 0.0001f)); }

    // ビットマップの数
    unsigned int GetNumBitmap() { return (int)m_BitmapArray.size();}
    // カラーマップの数
    unsigned int GetNumColorBitmap()
    {
        unsigned int numColMap = 0;

        for(int i = 0; i < (int)GetNumBitmap(); i++)
        {
            if(!GetBitmap(i)->isBump) numColMap++;
        }
        return numColMap;
    }

    // ビットマップ情報の取得
    MaxBitmapInfo* GetBitmap(int id) { return &(m_BitmapArray[id]); }

    // ビットマップの追加
    bool AddBitmap(BitmapTex* bmtex, int id);

    // IFLファイルをパースする
    bool parseIFL(CStr &fn, MaxBitmapInfo* bmiParent, nn::gfx::tool::dcc::utility::RSceneMaterials &sceneMtls, nn::gfx::tool::dcc::RSampler& sampler);
#if !defined( NW4F_C3T_DELETE )
    // ビットマップからRImageを作成
    bool CreateRImage(MaxBitmapInfo& bmi);
#endif
    // バンプマップで使用するテクスチャ、UV座標を決定する
    void DecideBumpTexInfo(vector<int> mapCh);

    //情報をFMaterialにコピーする
    void CopyToFMaterial(nn::gfx::tool::dcc::utility::RSceneMaterials &sceneMtls, nn::gfx::tool::dcc::utility::FMaterial* rmat, nn::gfx::tool::dcc::RIntArray& mapCh, nn::gfx::tool::dcc::RIntArray& hintCh);

    static bool exportTexture;
    // IFL ファイル用にアニメーション範囲を登録する。
    static int m_AnimStart_, m_AnimEnd_;
    static int m_SubStart_, m_SubEnd_, m_SubStep_;
    static void setAnimRange(int s, int e, int subS, int subE, int step)
    {
        m_AnimStart_ = s;
        m_AnimEnd_ = e;
        m_SubStart_ = subS;
        m_SubEnd_ = subE;
        m_SubStep_ = step;
    }
};

class MultiMtlInfo
{
  public:
    typedef map<int, MtlInfo*> subMtlMap;
    subMtlMap m_SubMtl;
    CStr m_OutFolder;

    //強制的に使用するCafeのUV座標を表すフラグ
    bool	m_ForceUseCafeUV[nn::gfx::tool::dcc::RPrimVtx::VTX_TEX_MAX];

  public:

    MultiMtlInfo()
    {
        for(int i = 0; i < nn::gfx::tool::dcc::RPrimVtx::VTX_TEX_MAX; i++) { m_ForceUseCafeUV[i] = false; }
    }
    ~MultiMtlInfo()
    {
        subMtlMap::iterator it = m_SubMtl.begin();
        while(it != m_SubMtl.end())
        {
            if(it->second)
            {
                delete it->second;
                it->second = nullptr;
            }
            ++it;
        }
    }
    bool Init(Mtl* maxMtl, bool exportTex);
    void SetOutFolder(CStr path){ m_OutFolder = path;};

    int GetNumSubMtl(){ return static_cast<UINT>(m_SubMtl.size()); };
    MtlInfo* AddSubMtl(int id);
    MtlInfo* GetSubMtl(int id);
};
