﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nns/gfx/gfx_PrimitiveRenderer.h>



namespace detail {


//---------------------------------------------------------------------------
//! @brief  基底クラスです。
//---------------------------------------------------------------------------
class Grid
{
public:
    //---------------------------------------------------------------------------
    //! @brief  描画メソッドです。
    //---------------------------------------------------------------------------
    virtual void ProcDraw( nn::gfx::CommandBuffer* pCommandBuffer, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer )
    {
        NN_UNUSED( pCommandBuffer );
        NN_UNUSED( pPrimitiveRenderer );
    }
};


//---------------------------------------------------------------------------
//! @brief  キューブグリッドクラスです。
//---------------------------------------------------------------------------
class CubeGrid : public Grid
{
public:
    //---------------------------------------------------------------------------
    //! @brief  標準背景描画メソッドです。
    //---------------------------------------------------------------------------
    virtual void ProcDraw( nn::gfx::CommandBuffer* pCommandBuffer, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer )
    {
        int cnt = 0;
        for ( int i = -5; i < 5; i++ )
        {
            for ( int j = -5; j < 5; j++ )
            {
                nn::util::Vector3fType center = { i * 10.f + 5.f, 0.f, j * 10.f + 5.f };
                nn::util::Vector3fType size   = { 10.f, 0.1f, 10.f };

                nn::util::Uint8x4 color = { { 32, 32, 32, 255 } };
                if ( cnt%2 == 0 )
                {
                    color.v[0] = 64;
                    color.v[1] = 64;
                    color.v[2] = 64;
                }
                pPrimitiveRenderer->SetColor(color);
                pPrimitiveRenderer->DrawCube( pCommandBuffer,
                    nns::gfx::PrimitiveRenderer::Surface::Surface_Solid, center, size);
                cnt++;
            }
            cnt++;
        }
    }
};

//---------------------------------------------------------------------------
//! @brief  標準グリッド描画クラスです。
//---------------------------------------------------------------------------
class DefaultGrid : public Grid
{
public:
    //---------------------------------------------------------------------------
    //! @brief  標準グリッド描画メソッドです。
    //---------------------------------------------------------------------------
    virtual void ProcDraw( nn::gfx::CommandBuffer* pCommandBuffer, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer )
    {
        nn::util::Uint8x4 color = { { 255, 255, 255, 255 } };
        nn::util::Uint8x4 red = { { 255, 0, 0, 255 } };
        nn::util::Uint8x4 blue = { { 0, 0, 255, 255 } };
        nn::util::Uint8x4 green = { { 0, 255, 0, 255 } };

        pPrimitiveRenderer->SetLineWidth(1.f);
        pPrimitiveRenderer->SetColor(color);

        float interval = -50;
        for (int i = 0; i < 11; i++)
        {
            {
                nn::util::Vector3fType from;
                nn::util::Vector3fType to;
                nn::util::VectorSet(&from, -50.f, 0.f, interval);
                nn::util::VectorSet(&to, 50.f, 0.f, interval);
                pPrimitiveRenderer->DrawLine( pCommandBuffer, from, to);
                nn::util::VectorSet(&from, interval, 0.f, -50.f);
                nn::util::VectorSet(&to, interval, 0.f, 50.f);
                pPrimitiveRenderer->DrawLine( pCommandBuffer, from, to);
            }
            interval += 10;
        }

        nn::util::Vector3fType zeroVector;
        nn::util::VectorSet(&zeroVector, 0.f, 0.f, 0.f);
        nn::util::Vector3fType axisPos;
        nn::util::VectorSet(&axisPos, 10.f, 0.f, 0.f);
        pPrimitiveRenderer->SetLineWidth(4.f);
        pPrimitiveRenderer->SetColor(red);
        pPrimitiveRenderer->DrawLine( pCommandBuffer, zeroVector, axisPos );
        pPrimitiveRenderer->SetLineWidth(4.f);
        nn::util::VectorSet(&axisPos, 0.f, 0.f, 10.f);
        pPrimitiveRenderer->SetColor(blue);
        pPrimitiveRenderer->DrawLine( pCommandBuffer, zeroVector, axisPos );
        pPrimitiveRenderer->SetLineWidth(4.f);
        nn::util::VectorSet(&axisPos, 0.f, 10.f, 0.f);
        pPrimitiveRenderer->SetColor(green);
        pPrimitiveRenderer->DrawLine( pCommandBuffer, zeroVector, axisPos );
    }
};


//---------------------------------------------------------------------------
//! @brief  高詳細グリッド描画クラスです。
//---------------------------------------------------------------------------
class HighGrid : public Grid
{
public:
    //---------------------------------------------------------------------------
    //! @brief  標準グリッド描画メソッドです。
    //---------------------------------------------------------------------------
    virtual void ProcDraw( nn::gfx::CommandBuffer* pCommandBuffer, nns::gfx::PrimitiveRenderer::Renderer* pPrimitiveRenderer )
    {
        nn::util::Uint8x4 color = { { 255, 255, 255, 255 } };
        nn::util::Uint8x4 red = { { 255, 0, 0, 255 } };
        nn::util::Uint8x4 blue = { { 0, 0, 255, 255 } };
        nn::util::Uint8x4 green = { { 0, 255, 0, 255 } };

        pPrimitiveRenderer->SetLineWidth(1.f);
        pPrimitiveRenderer->SetColor(color);

        float interval = -50;
        for (int i = 0; i < 101; i++)
        {
            {
                nn::util::Vector3fType from;
                nn::util::Vector3fType to;
                nn::util::VectorSet(&from, -50.f, 0.f, interval);
                nn::util::VectorSet(&to, 50.f, 0.f, interval);
                pPrimitiveRenderer->DrawLine( pCommandBuffer, from, to);
                nn::util::VectorSet(&from, interval, 0.f, -50.f);
                nn::util::VectorSet(&to, interval, 0.f, 50.f);
                pPrimitiveRenderer->DrawLine( pCommandBuffer, from, to);
            }
            interval += 1;
        }

        nn::util::Vector3fType zeroVector;
        nn::util::VectorSet(&zeroVector, 0.f, 0.f, 0.f);
        nn::util::Vector3fType axisPos;
        nn::util::VectorSet(&axisPos, 10.f, 0.f, 0.f);
        pPrimitiveRenderer->SetLineWidth(4.f);
        pPrimitiveRenderer->SetColor(red);
        pPrimitiveRenderer->DrawLine( pCommandBuffer, zeroVector, axisPos);
        nn::util::VectorSet(&axisPos, 0.f, 0.f, 10.f);
        pPrimitiveRenderer->SetLineWidth(4.f);
        pPrimitiveRenderer->SetColor(blue);
        pPrimitiveRenderer->DrawLine( pCommandBuffer, zeroVector, axisPos);
        nn::util::VectorSet(&axisPos, 0.f, 10.f, 0.f);
        pPrimitiveRenderer->SetLineWidth(4.f);
        pPrimitiveRenderer->SetColor(green);
        pPrimitiveRenderer->DrawLine( pCommandBuffer, zeroVector, axisPos);
    }
};

} // namespace detail
