﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <util/UtilProcess.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

bool CmdProcess::Run(const RunArg& arg)
{
    m_ProcessInfo.reset(new PROCESS_INFORMATION());
    STARTUPINFO si;
    ZeroMemory(&si,sizeof(si));
    si.cb = sizeof(si);
    if (CreateProcess(arg.appName, arg.cmdLine, nullptr, nullptr, FALSE,
        CREATE_UNICODE_ENVIRONMENT | NORMAL_PRIORITY_CLASS,
        nullptr, nullptr, &si, m_ProcessInfo.get()))
    {
        return true;
    }
    else
    {
        m_ProcessInfo.reset();
        return false;
    }
}

int CmdProcess::WaitForExit(uint millisecs)
{
    if (m_ProcessInfo.get())
    {
        WaitForSingleObject(m_ProcessInfo->hProcess, millisecs);

        union
        {
            int sVal;
            DWORD uVal;
        } exitCode;

        GetExitCodeProcess(m_ProcessInfo->hProcess, &exitCode.uVal);
        CloseHandle(m_ProcessInfo->hThread);
        CloseHandle(m_ProcessInfo->hProcess);

        m_ProcessInfo.reset();
        return exitCode.sVal;
    }
    else
    {
        return EXIT_SUCCESS;
    }
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
