﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <cstdint>

#include <util/UtilStringRef.h>
#include <util/UtilInline.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

typedef int8_t s8;
typedef int16_t s16;
typedef int32_t s32;
typedef int64_t s64;

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

typedef u8 bit8;
typedef u16 bit16;
typedef u32 bit32;
typedef u64 bit64;

typedef unsigned int uint;
typedef wchar_t char16;

struct LiteralStr // deprecated
{
    const char* str;
    size_t len;

    operator StringRef() const { return StringRef(str, len); }
};

struct RefBoneWeight
{
    int index;
    float weight;
};

class RefBoneWeightFinder
{
public:
    RefBoneWeightFinder(int boneIndex)
        : m_BoneIndex(boneIndex) {}

    bool operator()(const RefBoneWeight& target)
    {
        return target.index == m_BoneIndex;
    }
private:
    int m_BoneIndex;
};

#pragma warning(push)
#pragma warning(disable:4201)

struct Vec2_t
{
    union
    {
        struct { float x, y; };
        float a[2];
    };
};

struct Vec3_t
{
    union
    {
        struct { float x, y, z; };
        float a[3];
    };
};

struct Vec4_t
{
    union
    {
        struct { float x, y, z, w; };
        float a[4];
    };
};

struct Quat_t
{
    union
    {
        struct { float x, y, z, w; };
        float a[4];
    };
};

struct Mtx22_t
{
    union
    {
        struct { float m00, m01, m10, m11; };
        float a[4];
        float m[2][2];
        Vec2_t v[2];
    };
};

struct Mtx23_t
{
    union
    {
        struct { float m00, m01, m02, m10, m11, m12; };
        float a[6];
        float m[2][3];
        Vec3_t v[2];
    };
};

struct Mtx33_t
{
    union
    {
        struct { float m00, m01, m02, m10, m11, m12, m20, m21, m22; };
        float a[9];
        float m[3][3];
        Vec3_t v[3];
    };
};

struct Mtx34_t
{
    union
    {
        struct { float m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23; };
        float a[12];
        float m[3][4];
        Vec4_t v[3];
    };
};

struct Mtx44_t
{
    union
    {
        struct {
            float m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33;
        };
        float a[16];
        float m[4][4];
        Vec4_t v[4];
    };
};

#pragma warning(pop)

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
