﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <util/types.h>

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <Windows.h>
#include <eh.h>

#pragma warning(push)
#pragma warning(disable:4091)
#include <dbghelp.h>
#pragma warning(pop)

typedef struct _PROCESS_INFORMATION PROCESS_INFORMATION;

namespace nw { namespace g3d { namespace tool {
namespace util {

class CmdProcess
{
public:

    struct RunArg;
    bool Run(const RunArg& arg);

    int WaitForExit(uint millisecs);

private:
    std::unique_ptr<PROCESS_INFORMATION> m_ProcessInfo;
};

struct CmdProcess::RunArg
{
    RunArg()
        : appName(nullptr)
        , cmdLine(nullptr)
    {
    }

    const wchar_t* appName;
    wchar_t* cmdLine;
};

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
