﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <util/types.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

enum
{
    DEFAULT_ALIGNMENT = 4
};

inline
void* AddOffset(void* ptr, size_t offset)
{
    return static_cast<char*>(ptr) + offset;
}

inline
const void* AddOffset(const void* ptr, size_t offset)
{
    return static_cast<const char*>(ptr) + offset;
}

template <typename ResultT>
inline
ResultT* AddOffset(void* ptr, size_t offset)
{
    return static_cast<ResultT*>(AddOffset(ptr, offset));
}

template <typename ResultT>
inline
const ResultT* AddOffset(const void* ptr, size_t offset)
{
    return static_cast<const ResultT*>(AddOffset(ptr, offset));
}

inline size_t Align(size_t size, size_t alignment = DEFAULT_ALIGNMENT)
{
    size_t mask = alignment - 1;
    return (size + mask) & ~mask;
}

inline void* Align(void* ptr, size_t alignment = DEFAULT_ALIGNMENT)
{
    return reinterpret_cast<void*>(Align(reinterpret_cast<size_t>(ptr), alignment));
}

inline const void* Align(const void* ptr, size_t alignment = DEFAULT_ALIGNMENT)
{
    return reinterpret_cast<void*>(Align(reinterpret_cast<size_t>(ptr), alignment));
}

} // namespace util
} // namespace tool
} // namespace g3d
} // namespace nw
