﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <Windows.h>
#include <eh.h>

#pragma warning(push)
#pragma warning(disable:4091)
#include <dbghelp.h>
#pragma warning(pop)

namespace nw { namespace g3d { namespace tool {
namespace util {

//! 指定したディレクトリを内部のファイルごと削除します。
void DeleteDirectory(LPCTSTR lpPathName);

//! 指定したディレクトリまでのフォルダも含めて作成します。
BOOL CreateDirectory(LPCTSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes);

template<typename String, typename Separator>
inline String GetBaseName(const String& fullpath, const Separator sep)
{
    String::size_type basePos = fullpath.rfind(sep);

    // ベースファイル名取得
    if( basePos != String::npos )
    {
        return fullpath.substr(basePos + 1);
    }

    return fullpath;
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
